/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef USLIDER_H
#define USLIDER_H

#include <QSlider>
#include <QPaintEvent>
#include <QWidget>
#include <QStringList>

class Uslider : public QSlider
{

public:
    Uslider(QStringList list, int paintValue = 1);
    Uslider(Qt::Orientation orientation, QWidget *parent = nullptr, int paintValue = 0);
    Uslider(QWidget *parent = nullptr, int paintValue = 0);
    QStringList scaleList;

protected:
    void mousePressEvent(QMouseEvent *ev);
    void paintEvent(QPaintEvent *ev);
    void wheelEvent(QWheelEvent *ev);
    void leaveEvent(QEvent *ev);
private:
    int paintValue;
    bool isMouseCliked = false;
};

#endif // USLIDER_H

