/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.util.Log;
import org.chefproject.core.Notification;
import org.chefproject.core.NotificationEdit;
import org.chefproject.core.StorageUser;
import org.chefproject.service.component.BaseDbSingleStorage;
import org.chefproject.service.component.BaseNotificationService;

public class DbNotificationService
extends BaseNotificationService {
    protected String m_notificationTableName = "CHEF_NOTIFICATION";
    protected boolean m_locksInDb = true;

    public void init() throws InitializationException {
        this.m_notificationTableName = this.getProperties().getProperty("notificationTable", this.m_notificationTableName);
        this.m_locksInDb = new Boolean(this.getProperties().getProperty("locks-db", "true"));
        super.init();
        Log.info("chef", this + ".init(): notification table: " + this.m_notificationTableName);
    }

    protected BaseNotificationService.Storage newStorage() {
        return new DbStorage(this);
    }

    protected class DbStorage
    extends BaseDbSingleStorage
    implements BaseNotificationService.Storage {
        public DbStorage(StorageUser user) {
            super(DbNotificationService.this.m_notificationTableName, "NOTIFICATION_ID", null, DbNotificationService.this.m_locksInDb, "notification", user);
        }

        public boolean check(String id) {
            return super.checkResource(id);
        }

        public Notification get(String id) {
            return (Notification)super.getResource(id);
        }

        public List getAll() {
            return super.getAllResources();
        }

        public List getAll(String function) {
            Vector<Notification> rv = new Vector<Notification>();
            if (function == null) {
                return rv;
            }
            List all = super.getAllResources();
            Iterator it = all.iterator();
            while (it.hasNext()) {
                Notification notification = (Notification)it.next();
                if (!function.equals(notification.getFunction())) continue;
                rv.add(notification);
            }
            return rv;
        }

        public NotificationEdit put(String id) {
            return (NotificationEdit)super.putResource(id, null);
        }

        public NotificationEdit edit(String id) {
            return (NotificationEdit)super.editResource(id);
        }

        public void commit(NotificationEdit edit) {
            super.commitResource(edit);
        }

        public void cancel(NotificationEdit edit) {
            super.cancelResource(edit);
        }

        public void remove(NotificationEdit edit) {
            super.removeResource(edit);
        }
    }
}

