/* Copyright (C) 2022-2025 Free Software Foundation

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses>.  */

package org.gprofng.mpmt.overview;

import org.gprofng.mpmt.util.gui.AnUtility;

public class TurnerLabelPanel extends javax.swing.JPanel {

  /** Creates new form TurnerLabellPanel */
  public TurnerLabelPanel(String label1Text, String label2Text) {
    initComponents();
    setOpaque(false);
    label1.setFont(Overview.defaultBoldFont);
    label2.setFont(Overview.defaultPlainFont);
    label1.setText(label1Text);
    AnUtility.setAccessibleContext(label1.getAccessibleContext(), label1.getText());
    AnUtility.setAccessibleContext(label2.getAccessibleContext(), " ");
    AnUtility.setAccessibleContext(hyphenLabel.getAccessibleContext(), " ");
    if (label2Text != null) {
      label2.setText(label2Text);
    } else {
      hyphenLabel.setVisible(false);
    }
  }

  /**
   * This method is called from within the constructor to initialize the form. WARNING: Do NOT
   * modify this code. The content of this method is always regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {
    java.awt.GridBagConstraints gridBagConstraints;

    label1 = new javax.swing.JLabel();
    hyphenLabel = new javax.swing.JLabel();
    label2 = new javax.swing.JLabel();

    setLayout(new java.awt.GridBagLayout());
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 0;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    add(label1, gridBagConstraints);

    hyphenLabel.setText(":");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 1;
    gridBagConstraints.gridy = 0;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 6);
    add(hyphenLabel, gridBagConstraints);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 2;
    gridBagConstraints.gridy = 0;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.weightx = 1.0;
    add(label2, gridBagConstraints);
  } // </editor-fold>//GEN-END:initComponents
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JLabel hyphenLabel;
  private javax.swing.JLabel label1;
  private javax.swing.JLabel label2;
  // End of variables declaration//GEN-END:variables
}
