/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.datatype.DatatypeLibraryLoader;
import com.thaiopensource.relaxng.impl.CombineSchema;
import com.thaiopensource.relaxng.impl.FeasibleIdTypeMapSchema;
import com.thaiopensource.relaxng.impl.FeasibleTransform;
import com.thaiopensource.relaxng.impl.IdTypeMap;
import com.thaiopensource.relaxng.impl.IdTypeMapBuilder;
import com.thaiopensource.relaxng.impl.IdTypeMapSchema;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternSchema;
import com.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import com.thaiopensource.relaxng.impl.SchemaPatternBuilder;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.Parseable;
import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.AbstractSchema;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.validate.prop.wrap.WrapProperty;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import java.io.IOException;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class SchemaReaderImpl
implements SchemaReader {
    private static final PropertyId[] supportedPropertyIds = new PropertyId[]{ValidateProperty.XML_READER_CREATOR, ValidateProperty.ERROR_HANDLER, RngProperty.DATATYPE_LIBRARY_FACTORY, RngProperty.CHECK_ID_IDREF, RngProperty.FEASIBLE, WrapProperty.ATTRIBUTE_OWNER};

    public Schema createSchema(InputSource inputSource, PropertyMap propertyMap) throws IOException, SAXException, IncorrectSchemaException {
        SchemaPatternBuilder schemaPatternBuilder = new SchemaPatternBuilder();
        XMLReaderCreator xMLReaderCreator = ValidateProperty.XML_READER_CREATOR.get(propertyMap);
        ErrorHandler errorHandler = ValidateProperty.ERROR_HANDLER.get(propertyMap);
        DatatypeLibraryFactory datatypeLibraryFactory = RngProperty.DATATYPE_LIBRARY_FACTORY.get(propertyMap);
        if (datatypeLibraryFactory == null) {
            datatypeLibraryFactory = new DatatypeLibraryLoader();
        }
        try {
            Pattern pattern = SchemaBuilderImpl.parse(this.createParseable(xMLReaderCreator, inputSource, errorHandler), errorHandler, datatypeLibraryFactory, schemaPatternBuilder, propertyMap.contains(WrapProperty.ATTRIBUTE_OWNER));
            return SchemaReaderImpl.wrapPattern(pattern, schemaPatternBuilder, propertyMap);
        }
        catch (IllegalSchemaException illegalSchemaException) {
            throw new IncorrectSchemaException();
        }
    }

    public Option getOption(String string) {
        return RngProperty.getOption(string);
    }

    static Schema wrapPattern(Pattern pattern, SchemaPatternBuilder schemaPatternBuilder, PropertyMap propertyMap) throws SAXException, IncorrectSchemaException {
        if ((propertyMap = AbstractSchema.filterProperties(propertyMap, supportedPropertyIds)).contains(RngProperty.FEASIBLE)) {
            pattern = FeasibleTransform.transform(schemaPatternBuilder, pattern);
        }
        AbstractSchema abstractSchema = new PatternSchema(schemaPatternBuilder, pattern, propertyMap);
        if (schemaPatternBuilder.hasIdTypes() && propertyMap.contains(RngProperty.CHECK_ID_IDREF)) {
            ErrorHandler errorHandler = ValidateProperty.ERROR_HANDLER.get(propertyMap);
            IdTypeMap idTypeMap = new IdTypeMapBuilder(errorHandler, pattern).getIdTypeMap();
            if (idTypeMap == null) {
                throw new IncorrectSchemaException();
            }
            AbstractSchema abstractSchema2 = propertyMap.contains(RngProperty.FEASIBLE) ? new FeasibleIdTypeMapSchema(idTypeMap, propertyMap) : new IdTypeMapSchema(idTypeMap, propertyMap);
            abstractSchema = new CombineSchema(abstractSchema, abstractSchema2, propertyMap);
        }
        return abstractSchema;
    }

    protected abstract Parseable createParseable(XMLReaderCreator var1, InputSource var2, ErrorHandler var3);
}

