// SPDX-License-Identifier: GPL-2.0
//
// src4xxx.h  --  SRC4XXX ALSA SoC audio driver
//
// Copyright 2021-2022 Deqx Pty Ltd
// Author: Matt R Flax <flatmax@flatmax.com>

#ifndef __SRC4XXX_H__
#define __SRC4XXX_H__

#define SRC4XXX_RES_00 0x00
#define SRC4XXX_PWR_RST_01 0x01
#define SRC4XXX_RESET 0x80
#define SRC4XXX_POWER_DOWN 0x00
#define SRC4XXX_POWER_ENABLE 0x20
#define SRC4XXX_ENABLE_SRC 0x1
#define SRC4XXX_ENABLE_SRC_SHIFT 0
#define SRC4XXX_ENABLE_DIR 0x2
#define SRC4XXX_ENABLE_DIR_SHIFT 1
#define SRC4XXX_ENABLE_DIT 0x4
#define SRC4XXX_ENABLE_DIT_SHIFT 2
#define SRC4XXX_ENABLE_PORT_B 0x8
#define SRC4XXX_ENABLE_PORT_B_SHIFT 3
#define SRC4XXX_ENABLE_PORT_A 0x10
#define SRC4XXX_ENABLE_PORT_A_SHIFT 4

#define SRC4XXX_PORTA_CTL_03 0x03
#define SRC4XXX_BUS_MASTER 0x8
#define SRC4XXX_BUS_LEFT_J 0x0
#define SRC4XXX_BUS_I2S 0x1
#define SRC4XXX_BUS_RIGHT_J_16 0x4
#define SRC4XXX_BUS_RIGHT_J_18 0x5
#define SRC4XXX_BUS_RIGHT_J_20 0x6
#define SRC4XXX_BUS_RIGHT_J_24 0x7
#define SRC4XXX_BUS_FMT_MS_MASK 0xf

#define SRC4XXX_PORTA_CTL_04 0x04
#define SRC4XXX_MCLK_DIV_MASK 0x3

#define SRC4XXX_BUS_FMT(id) (SRC4XXX_PORTA_CTL_03+2*id)
#define SRC4XXX_BUS_CLK(id) (SRC4XXX_PORTA_CTL_04+2*id)

#define SRC4XXX_PORTB_CTL_05 0x05
#define SRC4XXX_PORTB_CTL_06 0x06

#define SRC4XXX_TX_CTL_07 0x07
#define SRC4XXX_TX_MCLK_DIV_MASK 0x60
#define SRC4XXX_TX_MCLK_DIV_SHIFT 5

#define SRC4XXX_TX_CTL_08 0x08
#define SRC4XXX_TX_CTL_09 0x09
#define SRC4XXX_SRC_DIT_IRQ_MSK_0B 0x0B
#define SRC4XXX_SRC_BTI_EN 0x01
#define SRC4XXX_SRC_TSLIP_EN 0x02
#define SRC4XXX_SRC_DIT_IRQ_MODE_0C 0x0C
#define SRC4XXX_RCV_CTL_0D 0x0D
#define SRC4XXX_RXCLK_RXCKI 0x0
#define SRC4XXX_RXCLK_MCLK 0x8
#define SRC4XXX_RCV_CTL_0E 0x0E
#define SRC4XXX_REC_MCLK_EN 0x1
#define SRC4XXX_PLL2_DIV_0 (0x0<<1)
#define SRC4XXX_PLL2_DIV_2 (0x1<<1)
#define SRC4XXX_PLL2_DIV_4 (0x2<<1)
#define SRC4XXX_PLL2_DIV_8 (0x3<<1)
#define SRC4XXX_PLL2_LOL 0x8
#define SRC4XXX_RCV_PLL_0F 0x0F
#define SRC4XXX_RCV_PLL_10 0x10
#define SRC4XXX_RCV_PLL_11 0x11
#define SRC4XXX_RVC_IRQ_MSK_16 0x16
#define SRC4XXX_RVC_IRQ_MSK_17 0x17
#define SRC4XXX_RVC_IRQ_MODE_18 0x18
#define SRC4XXX_RVC_IRQ_MODE_19 0x19
#define SRC4XXX_RVC_IRQ_MODE_1A 0x1A
#define SRC4XXX_GPIO_1_1B 0x1B
#define SRC4XXX_GPIO_2_1C 0x1C
#define SRC4XXX_GPIO_3_1D 0x1D
#define SRC4XXX_GPIO_4_1E 0x1E
#define SRC4XXX_SCR_CTL_2D 0x2D
#define SRC4XXX_SCR_CTL_2E 0x2E
#define SRC4XXX_SCR_CTL_2F 0x2F
#define SRC4XXX_SCR_CTL_30 0x30
#define SRC4XXX_SCR_CTL_31 0x31
#define SRC4XXX_PAGE_SEL_7F 0x7F

// read only registers
#define SRC4XXX_GLOBAL_ITR_STS_02 0x02
#define SRC4XXX_SRC_DIT_STS_0A 0x0A
#define SRC4XXX_NON_AUDIO_D_12 0x12
#define SRC4XXX_RVC_STS_13 0x13
#define SRC4XXX_RVC_STS_14 0x14
#define SRC4XXX_RVC_STS_15 0x15
#define SRC4XXX_SUB_CODE_1F 0x1F
#define SRC4XXX_SUB_CODE_20 0x20
#define SRC4XXX_SUB_CODE_21 0x21
#define SRC4XXX_SUB_CODE_22 0x22
#define SRC4XXX_SUB_CODE_23 0x23
#define SRC4XXX_SUB_CODE_24 0x24
#define SRC4XXX_SUB_CODE_25 0x25
#define SRC4XXX_SUB_CODE_26 0x26
#define SRC4XXX_SUB_CODE_27 0x27
#define SRC4XXX_SUB_CODE_28 0x28
#define SRC4XXX_PC_PREAMBLE_HI_29 0x29
#define SRC4XXX_PC_PREAMBLE_LO_2A 0x2A
#define SRC4XXX_PD_PREAMBLE_HI_2B 0x2B
#define SRC4XXX_PC_PREAMBLE_LO_2C 0x2C
#define SRC4XXX_IO_RATIO_32 0x32
#define SRC4XXX_IO_RATIO_33 0x33

int src4xxx_probe(struct device *dev, struct regmap *regmap,
		void (*switch_mode)(struct device *dev));
extern const struct regmap_config src4xxx_regmap_config;

#endif /* __SRC4XXX_H__ */
