#!/usr/bin/perl

require "shellwords.pl";

if (@ARGV < 1) {
  print "
  usage: % AztecOO_string_maps_builder.pl file.txt
    where file.txt contains the list of Aztec macros such as AZ_solver.
    These macros should be divided into two lists:
    keys (such as AZ_solver), and values (such as AZ_gmres).
    These lists should be preceded by lines which say KEYS or VALUES,
    respectively.

    Example file.txt:
    KEYS
      AZ_solver
      AZ_precond
      ...
    VALUES
      AZ_cg
      AZ_gmres
      ...

    Output is echoed to the screen. This script is used to create
    AztecOO_string_maps.cpp as follows:
    % AztecOO_string_maps_builder.pl file.txt > AztecOO_string_maps.cpp

";
  exit 1;
}

open(INFILE, $ARGV[0]) or die "Can't open input file ",$ARGV[0];

print "
//
//This file is generated by the script AztecOO_string_maps_builder.pl.
//Example: % AztecOO_string_maps_builder.pl \
//             AztecOO_string_maps.txt > AztecOO_string_maps.cpp
//

#include <AztecOO_string_maps.h>

#ifdef HAVE_AZTECOO_TEUCHOS
//=============================================================================
Teuchos::map<string,int>& AztecOO_key_map()
{
  static Teuchos::map<string,int> azoo_key_map;
  return( azoo_key_map );
}

//=============================================================================
Teuchos::map<string,int>& AztecOO_value_map()
{
  static Teuchos::map<string,int> azoo_value_map;
  return( azoo_value_map );
}

//=============================================================================
void AztecOO_initialize_maps()
{
  static bool maps_already_initialized = false;
  if (maps_already_initialized) {
    return;
  }
";

$whichmap = "not-set";

while(<INFILE>) {
  chop;
  if ($_ ne "") {
    $line = $_;
    $line =~ s/^\s+//;
    $line =~ s/\s+$//;
    $ucline = uc($line);

    if ($ucline eq "KEYS") {
      $whichmap = "azoo_key_map";
      print "\n  Teuchos::map<string,int>& ",$whichmap," = AztecOO_key_map();\n\n";
    }
    elsif ($ucline eq "VALUES") {
      $whichmap = "azoo_value_map";
      print "\n  Teuchos::map<string,int>& ",$whichmap," = AztecOO_value_map();\n\n";
    }
    else {
      if ($whichmap eq "not-set") {
        print " ERROR, lists of strings need to be preceded by KEYS or VALUES\n";
        exit 1;
      }
      print "  ",$whichmap,"[\"",$ucline,"\"] = ",$line,";\n";
    }
  }
}

print "
  maps_already_initialized = true;
}
#endif //HAVE_AZTECOO_TEUCHOS

";

