<!-- markdownlint-disable first-line-h1 -->
### Defect fixes

The following known issues in ROCm v5.3.2 are fixed in this release.

#### Peer-to-peer DMA mapping errors with SLES and RHEL

Peer-to-Peer Direct Memory Access (DMA) mapping errors on Dell systems (R7525 and R750XA) with
SLES 15 SP3/SP4 and RHEL 9.0 are fixed in this release.

Previously, running `rocminfo` resulted in Peer-to-Peer DMA mapping errors.

#### RCCL tuning table

The RCCL tuning table is updated for supported platforms.

#### SGEMM (F32 GEMM) routines in rocBLAS

Functional correctness failures in SGEMM (F32 GEMM) routines in rocBLAS for certain problem sizes
and ranges are fixed in this release.

### Known issues

This section consists of known issues in this release.

#### AMD Instinct™ MI200 SRIOV virtualization issue

There is a known issue in this ROCm v5.3 release with all AMD Instinct™ MI200 devices running within
a virtual function (VF) under SRIOV virtualization. This issue will likely impact the functionality of
SRIOV-based workloads but does not impact Discrete Device Assignment (DDA) or bare metal.

Until a fix is provided, users should rely on ROCm v5.2.3 to support their SRIOV workloads.

#### AMD Instinct™ MI200 firmware updates

Customers cannot update the Integrated Firmware Image (IFWI) for AMD Instinct™ MI200 GPUs.

An updated firmware maintenance bundle consisting of an installation tool and images specific to
AMD Instinct™ MI200 GPUs is under planning and will be available soon.

#### Known issue with rocThrust and rocPRIM libraries

There is a known known issue with rocThrust and rocPRIM libraries supporting iterator and types in
ROCm v5.3.x releases.

* `thrust::merge` no longer correctly supports different iterator types for `keys_input1` and
  `keys_input2`.

* `rocprim::device_merge` no longer correctly supports using different types for `keys_input1` and
  `keys_input2`.

This issue is currently under investigation and will be resolved in a future release.
