% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/criterion.R, R/has-file.R
\name{root_criterion}
\alias{root_criterion}
\alias{is.root_criterion}
\alias{as.root_criterion}
\alias{as.root_criterion.character}
\alias{as.root_criterion.root_criterion}
\alias{|.root_criterion}
\alias{has_file}
\alias{has_dir}
\alias{has_file_pattern}
\alias{has_dirname}
\title{Is a directory the project root?}
\usage{
root_criterion(testfun, desc, subdir = NULL)

is.root_criterion(x)

as.root_criterion(x)

\method{as.root_criterion}{character}(x)

\method{as.root_criterion}{root_criterion}(x)

\method{|}{root_criterion}(x, y)

has_file(filepath, contents = NULL, n = -1L)

has_dir(filepath)

has_file_pattern(pattern, contents = NULL, n = -1L)

has_dirname(dirname, subdir = NULL)
}
\arguments{
\item{testfun}{A function with one parameter that returns \code{TRUE}
if the directory specified by this parameter is the project root,
and \code{FALSE} otherwise. Can also be a list of such functions.}

\item{desc}{A textual description of the test criterion, of the same length
as \code{testfun}}

\item{subdir}{Subdirectories to start the search in, if found}

\item{x}{An object}

\item{y}{An object}

\item{filepath}{File path (can contain directories)}

\item{contents}{Regular expression to match the file contents}

\item{n}{integer.  The (maximal) number of lines to
    read.  Negative values indicate that one should read up to the end of
    input on the connection.}

\item{pattern}{Regular expression to match the file name}

\item{dirname}{A directory name, without subdirectories}
}
\value{
An S3 object of class \code{root_criterion} wit the following members:

\describe{
\item{\code{testfun}}{The \code{testfun} argument}
\item{\code{desc}}{The \code{desc} argument}
\item{\code{subdir}}{The \code{subdir} argument}
\item{\code{find_file}}{A function with \code{...} argument that returns
for a path relative to the root specified by this criterion.
The optional \code{path} argument specifies the starting directory,
which defaults to \code{"."}.
}
\item{\code{make_fix_file}}{A function with a \code{path} argument that
returns a function that finds paths relative to the root.  For a
criterion \code{cr}, the result of \code{cr$make_fix_file(".")(...)}
is identical to \code{cr$find_file(...)}. The function created by
\code{make_fix_file} can be saved to a variable to be more independent
of the current working directory.
}
}
}
\description{
Objects of the \code{root_criterion} class decide if a
given directory is a project root.
}
\details{
Construct criteria using \code{root_criterion} in a very general fashion
by specifying a function with a \code{path} argument, and a description.

The \code{as.root_criterion} function accepts objects of class
\code{root_criterion}, and character values; the latter will be
converted to criteria using \code{has_file}.

Root criteria can be combined with the \code{|} operator. The result is a
composite root criterion that requires either of the original criteria to
match.

The \code{has_file} function constructs a criterion that checks for the
existence of a specific file (which itself can be in a subdirectory of the
root) with specific contents.

The \code{has_dir} function constructs a criterion that checks for the
existence of a specific directory.

The \code{has_file_pattern} function constructs a criterion that checks for the
existence of a file that matches a pattern, with specific contents.

The \code{has_dirname} function constructs a criterion that checks if the
\code{\link[base:dirname]{base::dirname()}} has a specific name.
}
\examples{
root_criterion(function(path) file.exists(file.path(path, "somefile")), "has somefile")
has_file("DESCRIPTION")
is_r_package
is_r_package$find_file
\dontrun{
is_r_package$make_fix_file(".")
}
}
