% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ocens.r
\name{Ocens}
\alias{Ocens}
\title{Censored Ordinal Variable}
\usage{
Ocens(a, b = a)
}
\arguments{
\item{a}{variable for first column}

\item{b}{variable for second column}
}
\value{
a numeric matrix of class \code{Ocens}
}
\description{
Combines two variables \verb{a, b} into a 2-column matrix, preserving \code{label} and \code{units} attributes and converting character or factor variables into integers and added a \code{levels} attribute.  This is used to combine censoring points with regular points.  If both variables are already factors, their levels are distinctly combined starting with the levels for \code{a}.  Character variables are converted to factors.
}
\details{
Left censored values will have \code{-Inf} for \code{a} and right-censored values will have \code{Inf} for \code{b}.  Interval-censored observations will have \code{b} > \code{a} and both finite.  For factor or character variables it only makes sense to have interval censoring.

If there is no censoring, \code{a} is returned as an ordinary vector, with \code{label} and \code{units} attributes.
}
\author{
Frank Harrell
}
