% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_mi.R
\name{predict_mi}
\alias{predict_mi}
\title{Predict method for linear models with multiply imputed data}
\usage{
predict_mi(
  object,
  newdata,
  pool = TRUE,
  se.fit = FALSE,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  ...
)
}
\arguments{
\item{object}{A prediction model, either a single lm object or a list of lm
objects obtained from multiply imputed data (object can also be of class mira).}

\item{newdata}{An optional data frame in which to look for variables
with which to predict. Can be a data.frame, list, or mids object.
If omitted, the fitted values are used.}

\item{pool}{Logical indicating whether to pool the predictions (and potentially
obtain pooled prediction intervals).}

\item{se.fit}{A switch indicating if standard errors are required.}

\item{interval}{Type of interval calculation.  Can be abbreviated.}

\item{level}{Tolerance/confidence level.}

\item{...}{
  Arguments passed on to \code{\link[stats:predict.lm]{stats::predict.lm}}
  \describe{
    \item{\code{scale}}{Scale parameter for std.err. calculation.}
    \item{\code{df}}{Degrees of freedom for scale.}
    \item{\code{type}}{Type of prediction (response or model term).  Can be abbreviated.}
    \item{\code{terms}}{If \code{type = "terms"}, which terms (default is all
    terms), a \code{\link{character}} vector.}
    \item{\code{na.action}}{function determining what should be done with missing
    values in \code{newdata}.  The default is to predict \code{NA}.}
    \item{\code{pred.var}}{the variance(s) for future observations to be assumed
    for prediction intervals.  See \sQuote{Details}.}
    \item{\code{weights}}{variance weights for prediction.  This can be a numeric
    vector or a one-sided model formula.  In the latter case, it is
    interpreted as an expression evaluated in \code{newdata}.}
    \item{\code{rankdeficient}}{a \code{\link{character}} string specifying what
    should happen in the case of a rank deficient model, i.e., when
    \code{object$rank < ncol(model.matrix(object))}.
    \describe{
      \item{\code{"warnif"}:}{gives a \code{\link{warning}} only in case of
	predicting \sQuote{non-estimable} cases, i.e., vectors not in the
	same predictor subspace as the original data (with tolerance
	\code{tol}).  In that case, the non-estimable indices are also
	returned as attribute \code{"non-estim"} (see \code{rankdeficient="non-estim"}).}
      \item{\code{"simple"}:}{is back compatible to \R < 4.3.0, possibly giving dubious
	predictions in non-estimable cases, and always signalling a \code{\link{warning}}.}
      \item{\code{"non-estim"}:}{gives the same predictions without
	\code{\link{warning}}, and with an attribute \code{\link{attr}(*, "non-estim")}
	with indices in \code{1:nrow(newdata)} of new data observations
	which are deemed non-estimable.}
      \item{\code{"NA"}:    }{predicts \code{NA} for non-estimable new data,
	silently.  Often recommended in new code.}
      \item{\code{"NAwarn"}:}{predicts \code{NA} for non-estimable new data
	with a \code{\link{warning}}.}
    }
  }
    \item{\code{tol}}{non-negative number determining how non-estimability is
    determined in rank deficient cases.}
    \item{\code{verbose}}{\code{\link{logical}} indicating if messages should be
    produced about rank deficiency handling.}
  }}
}
\value{
If \code{pool = TRUE}, predict_mi produces a vector of predictions or a
matrix of predictions and bounds with column names \code{fit}, \code{lwr}, \code{upr} if
additionally \code{interval} is set. For \code{type = "terms"} this is a matrix with a
column per term and may have an attribute \code{"constant"}. If \code{se.fit = TRUE}, a
list is returned with the following components:
\itemize{
\item \code{fit}: vector or matrix as above
\item \code{se.fit}: standard error of \strong{pooled} predicted means
\item \verb{residual scale}: average residual standard deviations
\item \code{df}: degrees of freedom for residual (per observation) according to Barnard-
Rubin (1999).
}

If \code{pool = FALSE}, the function produces a list with predictions with the same
structure as \code{predict.lm}, with one list-element per imputed dataset.
}
\description{
Predict method for linear models with multiply imputed data
}
\examples{
# Dataframe with missings in X
# Create Imp and Lm object
dat <- mice::nhanes

# add indicator training and test
# first 20 for training, last 5 for testing
dat$set <- c(rep("train", 20), rep("test", 5))

# Make prediction matrix and ensure that set is not used as a predictor
predmat <- mice::make.predictorMatrix(dat)
predmat[,"set"] <- 0

# Impute missing values based on the train set
imp <- mice(dat, m = 5, maxit = 5 , seed = 1, predictorMatrix = predmat, 
  ignore = ifelse(dat$set == "test", TRUE, FALSE), print = FALSE)
impdats <- complete(imp, "all")

# extract the training and test data sets
traindats <- lapply(impdats, function(dat) subset(dat, set == "train", select = -set))
testdats <- lapply(impdats, function(dat) subset(dat, set == "test", select = -c(set)))

# Fit the prediction models, based on the imputed training data
fits <- lapply(traindats, function(dat) lm(age ~ bmi + hyp + chl, data = dat))

# pool the predictions with function
pool_preds <- mice::predict_mi(object = fits, newdata = testdats, 
  pool = TRUE, interval = "prediction", level = 0.95)
}
\seealso{
\code{\link[stats:lm]{stats::lm()}}, \code{\link[stats:predict.lm]{stats::predict.lm()}}, \code{\link[=mice]{mice()}}, \code{\link[=with.mids]{with.mids()}}
}
