% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R
\name{date-shifting}
\alias{date-shifting}
\alias{date_shift.Date}
\title{Shifting: date}
\usage{
\method{date_shift}{Date}(x, target, ..., which = "next", boundary = "keep")
}
\arguments{
\item{x}{\verb{[Date]}

A date vector.}

\item{target}{\verb{[weekday]}

A weekday created from \code{\link[=weekday]{weekday()}} to target.

Generally this is length 1, but can also be the same length as \code{x}.}

\item{...}{These dots are for future extensions and must be empty.}

\item{which}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"next"}: Shift to the next instance of the \code{target} weekday.
\item \verb{"previous}: Shift to the previous instance of the \code{target} weekday.
}}

\item{boundary}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"keep"}: If \code{x} is currently on the \code{target} weekday, return it.
\item \code{"advance"}: If \code{x} is currently on the \code{target} weekday, advance it
anyways.
}}
}
\value{
\code{x} shifted to the \code{target} weekday.
}
\description{
\code{date_shift()} shifts \code{x} to the \code{target} weekday. You can shift to the next
or previous weekday. If \code{x} is currently on the \code{target} weekday, you can
choose to leave it alone or advance it to the next instance of the \code{target}.

Weekday shifting is one of the easiest ways to floor by week while
controlling what is considered the first day of the week. You can also
accomplish this with the \code{origin} argument of \code{\link[=date_floor]{date_floor()}}, but this is
slightly easier.
}
\examples{
x <- as.Date("2019-01-01") + 0:1

# A Tuesday and Wednesday
as_weekday(x)

monday <- weekday(clock_weekdays$monday)

# Shift to the next Monday
date_shift(x, monday)

# Shift to the previous Monday
# This is an easy way to "floor by week" with a target weekday in mind
date_shift(x, monday, which = "previous")

# What about Tuesday?
tuesday <- weekday(clock_weekdays$tuesday)

# Notice that the day that was currently on a Tuesday was not shifted
date_shift(x, tuesday)

# You can force it to `"advance"`
date_shift(x, tuesday, boundary = "advance")
}
