% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso-year-week-day.R
\name{iso-year-week-day-count-between}
\alias{iso-year-week-day-count-between}
\alias{calendar_count_between.clock_iso_year_week_day}
\title{Counting: iso-year-week-day}
\usage{
\method{calendar_count_between}{clock_iso_year_week_day}(start, end, precision, ..., n = 1L)
}
\arguments{
\item{start, end}{\verb{[clock_iso_year_week_day]}

A pair of iso-year-week-day vectors. These will be recycled to their
common size.}

\item{precision}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"year"}
}}

\item{...}{These dots are for future extensions and must be empty.}

\item{n}{\verb{[positive integer(1)]}

A single positive integer specifying a multiple of \code{precision} to use.}
}
\value{
An integer representing the number of \code{precision} units between
\code{start} and \code{end}.
}
\description{
This is an iso-year-week-day method for the \code{\link[=calendar_count_between]{calendar_count_between()}}
generic. It counts the number of \code{precision} units between \code{start} and \code{end}
(i.e., the number of ISO years).
}
\examples{
# Compute the number of whole ISO years between two dates
x <- iso_year_week_day(2001, 1, 2)
y <- iso_year_week_day(2021, 1, c(1, 3))
calendar_count_between(x, y, "year")
}
