/* projects.c generated by valac 0.28.0.1-2361a, the Vala compiler
 * generated from projects.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksource.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
typedef struct _ProjectsPrivate ProjectsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_markup_parse_context_unref0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))

#define TYPE_LATEXILA_APP (latexila_app_get_type ())
#define LATEXILA_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXILA_APP, LatexilaApp))
#define LATEXILA_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXILA_APP, LatexilaAppClass))
#define IS_LATEXILA_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXILA_APP))
#define IS_LATEXILA_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXILA_APP))
#define LATEXILA_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXILA_APP, LatexilaAppClass))

typedef struct _LatexilaApp LatexilaApp;
typedef struct _LatexilaAppClass LatexilaAppClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _ParamSpecProjects ParamSpecProjects;

struct _Project {
	GFile* directory;
	GFile* main_file;
};

struct _Projects {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ProjectsPrivate * priv;
};

struct _ProjectsClass {
	GTypeClass parent_class;
	void (*finalize) (Projects *self);
};

struct _ProjectsPrivate {
	GeeLinkedList* projects;
	gboolean modified;
};

struct _ParamSpecProjects {
	GParamSpec parent_instance;
};


static gpointer projects_parent_class = NULL;
static Projects* projects_instance;
static Projects* projects_instance = NULL;

GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self, Project* dest);
void project_destroy (Project* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_projects (GValue* value, gpointer v_object);
void value_take_projects (GValue* value, gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
#define PROJECTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROJECTS, ProjectsPrivate))
enum  {
	PROJECTS_DUMMY_PROPERTY
};
static Projects* projects_new (void);
static Projects* projects_construct (GType object_type);
static GFile* projects_get_xml_file (Projects* self);
gchar* utils_load_file (GFile* file);
static void projects_parser_start (Projects* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error);
static void _projects_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error);
static void projects_update_all_documents (Projects* self);
static void projects_update_all_menus (Projects* self);
Projects* projects_get_default (void);
Project* projects_get (Projects* self, gint id);
GeeIterator* projects_iterator (Projects* self);
GType latexila_app_get_type (void) G_GNUC_CONST;
LatexilaApp* latexila_app_get_instance (void);
GType main_window_get_type (void) G_GNUC_CONST;
void main_window_update_config_project_sensitivity (MainWindow* self);
gboolean projects_add (Projects* self, Project* new_project, GFile** conflict_file);
static gboolean projects_conflict (Projects* self, GFile* dir1, GFile* dir2);
GType document_get_type (void) G_GNUC_CONST;
GeeList* latexila_app_get_documents (LatexilaApp* self);
gint document_get_project_id (Document* self);
GFile* document_get_location (Document* self);
void document_set_project_id (Document* self, gint value);
gboolean projects_change_main_file (Projects* self, gint num, GFile* new_main_file);
void projects_delete (Projects* self, gint num);
void projects_clear_all (Projects* self);
void projects_save (Projects* self);
void utils_delete_file (GFile* file);
gboolean utils_save_file (GFile* file, const gchar* contents, gboolean make_backup);
static void projects_finalize (Projects* obj);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void project_copy (const Project* self, Project* dest) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	_tmp0_ = (*self).directory;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).directory);
	(*dest).directory = _tmp1_;
	_tmp2_ = (*self).main_file;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 ((*dest).main_file);
	(*dest).main_file = _tmp3_;
}


void project_destroy (Project* self) {
	_g_object_unref0 ((*self).directory);
	_g_object_unref0 ((*self).main_file);
}


Project* project_dup (const Project* self) {
	Project* dup;
	dup = g_new0 (Project, 1);
	project_copy (self, dup);
	return dup;
}


void project_free (Project* self) {
	project_destroy (self);
	g_free (self);
}


GType project_get_type (void) {
	static volatile gsize project_type_id__volatile = 0;
	if (g_once_init_enter (&project_type_id__volatile)) {
		GType project_type_id;
		project_type_id = g_boxed_type_register_static ("Project", (GBoxedCopyFunc) project_dup, (GBoxedFreeFunc) project_free);
		g_once_init_leave (&project_type_id__volatile, project_type_id);
	}
	return project_type_id__volatile;
}


static void _projects_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error) {
	projects_parser_start ((Projects*) self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}


static Projects* projects_construct (GType object_type) {
	Projects* self = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	GFile* file = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gchar* contents = NULL;
	GFile* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	self = (Projects*) g_type_create_instance (object_type);
	_tmp0_ = gee_linked_list_new (TYPE_PROJECT, (GBoxedCopyFunc) project_dup, project_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->projects);
	self->priv->projects = _tmp0_;
	_tmp1_ = projects_get_xml_file (self);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
	if (!_tmp3_) {
		_g_object_unref0 (file);
		return self;
	}
	_tmp4_ = file;
	_tmp5_ = utils_load_file (_tmp4_);
	contents = _tmp5_;
	_tmp6_ = contents;
	if (_tmp6_ == NULL) {
		_g_free0 (contents);
		_g_object_unref0 (file);
		return self;
	}
	{
		GMarkupParser parser = {0};
		GMarkupParser _tmp7_ = {0};
		GMarkupParseContext* context = NULL;
		GMarkupParser _tmp8_ = {0};
		GMarkupParseContext* _tmp9_ = NULL;
		GMarkupParseContext* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		_tmp7_.start_element = _projects_parser_start_gmarkup_parser_start_element_func;
		_tmp7_.end_element = NULL;
		_tmp7_.text = NULL;
		_tmp7_.passthrough = NULL;
		_tmp7_.error = NULL;
		parser = _tmp7_;
		_tmp8_ = parser;
		_tmp9_ = g_markup_parse_context_new (&_tmp8_, 0, self, NULL);
		context = _tmp9_;
		_tmp10_ = context;
		_tmp11_ = contents;
		g_markup_parse_context_parse (_tmp10_, _tmp11_, (gssize) (-1), &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_markup_parse_context_unref0 (context);
			goto __catch40_g_error;
		}
		projects_update_all_documents (self);
		projects_update_all_menus (self);
		_g_markup_parse_context_unref0 (context);
	}
	goto __finally40;
	__catch40_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("projects.vala:59: Impossible to load the projects: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally40:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (contents);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (contents);
	_g_object_unref0 (file);
	return self;
}


static Projects* projects_new (void) {
	return projects_construct (TYPE_PROJECTS);
}


static gpointer _projects_ref0 (gpointer self) {
	return self ? projects_ref (self) : NULL;
}


Projects* projects_get_default (void) {
	Projects* result = NULL;
	Projects* _tmp0_ = NULL;
	Projects* _tmp2_ = NULL;
	Projects* _tmp3_ = NULL;
	_tmp0_ = projects_instance;
	if (_tmp0_ == NULL) {
		Projects* _tmp1_ = NULL;
		_tmp1_ = projects_new ();
		_projects_unref0 (projects_instance);
		projects_instance = _tmp1_;
	}
	_tmp2_ = projects_instance;
	_tmp3_ = _projects_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


Project* projects_get (Projects* self, gint id) {
	Project* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	GeeLinkedList* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gpointer _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = id;
	if (_tmp1_ >= 0) {
		gint _tmp2_ = 0;
		GeeLinkedList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp2_ = id;
		_tmp3_ = self->priv->projects;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp2_ < _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_val_if_fail (_tmp0_, NULL);
	_tmp6_ = self->priv->projects;
	_tmp7_ = id;
	_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _tmp7_);
	result = (Project*) _tmp8_;
	return result;
}


GeeIterator* projects_iterator (Projects* self) {
	GeeIterator* result = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	GeeIterator* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->projects;
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERATOR, GeeIterator);
	return result;
}


static void projects_update_all_menus (Projects* self) {
	LatexilaApp* _tmp0_ = NULL;
	LatexilaApp* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = latexila_app_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_application_get_windows ((GtkApplication*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp3_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* _tmp4_ = NULL;
			GtkWindow* window = NULL;
			_tmp4_ = _g_object_ref0 ((GtkWindow*) window_it->data);
			window = _tmp4_;
			{
				MainWindow* main_window = NULL;
				GtkWindow* _tmp5_ = NULL;
				MainWindow* _tmp6_ = NULL;
				MainWindow* _tmp7_ = NULL;
				_tmp5_ = window;
				_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp5_) : NULL);
				main_window = _tmp6_;
				_tmp7_ = main_window;
				main_window_update_config_project_sensitivity (_tmp7_);
				_g_object_unref0 (main_window);
				_g_object_unref0 (window);
			}
		}
	}
}


gboolean projects_add (Projects* self, Project* new_project, GFile** conflict_file) {
	GFile* _vala_conflict_file = NULL;
	gboolean result = FALSE;
	GeeLinkedList* _tmp22_ = NULL;
	Project _tmp23_ = {0};
	GeeList* docs = NULL;
	LatexilaApp* _tmp24_ = NULL;
	LatexilaApp* _tmp25_ = NULL;
	GeeList* _tmp26_ = NULL;
	GeeList* _tmp27_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (new_project != NULL, FALSE);
	_g_object_unref0 (_vala_conflict_file);
	_vala_conflict_file = NULL;
	{
		GeeLinkedList* _project_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _project_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _project_index = 0;
		_tmp0_ = self->priv->projects;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_project_list = _tmp1_;
		_tmp2_ = _project_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_project_size = _tmp4_;
		_project_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			Project project = {0};
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			Project* _tmp11_ = NULL;
			Project _tmp12_ = {0};
			Project _tmp13_ = {0};
			Project _tmp14_ = {0};
			GFile* _tmp15_ = NULL;
			Project _tmp16_ = {0};
			GFile* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
			_tmp5_ = _project_index;
			_project_index = _tmp5_ + 1;
			_tmp6_ = _project_index;
			_tmp7_ = _project_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _project_list;
			_tmp9_ = _project_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			_tmp11_ = (Project*) _tmp10_;
			project_copy (_tmp11_, &_tmp12_);
			_tmp13_ = _tmp12_;
			_project_free0 (_tmp11_);
			project = _tmp13_;
			_tmp14_ = project;
			_tmp15_ = _tmp14_.directory;
			_tmp16_ = *new_project;
			_tmp17_ = _tmp16_.directory;
			_tmp18_ = projects_conflict (self, _tmp15_, _tmp17_);
			if (_tmp18_) {
				Project _tmp19_ = {0};
				GFile* _tmp20_ = NULL;
				GFile* _tmp21_ = NULL;
				_tmp19_ = project;
				_tmp20_ = _tmp19_.directory;
				_tmp21_ = _g_object_ref0 (_tmp20_);
				_g_object_unref0 (_vala_conflict_file);
				_vala_conflict_file = _tmp21_;
				result = FALSE;
				project_destroy (&project);
				_g_object_unref0 (_project_list);
				if (conflict_file) {
					*conflict_file = _vala_conflict_file;
				} else {
					_g_object_unref0 (_vala_conflict_file);
				}
				return result;
			}
			project_destroy (&project);
		}
		_g_object_unref0 (_project_list);
	}
	_tmp22_ = self->priv->projects;
	_tmp23_ = *new_project;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, &_tmp23_);
	self->priv->modified = TRUE;
	_tmp24_ = latexila_app_get_instance ();
	_tmp25_ = _tmp24_;
	_tmp26_ = latexila_app_get_documents (_tmp25_);
	_tmp27_ = _tmp26_;
	_g_object_unref0 (_tmp25_);
	docs = _tmp27_;
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp28_ = NULL;
		GeeList* _tmp29_ = NULL;
		gint _doc_size = 0;
		GeeList* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		gint _doc_index = 0;
		_tmp28_ = docs;
		_tmp29_ = _g_object_ref0 (_tmp28_);
		_doc_list = _tmp29_;
		_tmp30_ = _doc_list;
		_tmp31_ = gee_collection_get_size ((GeeCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_doc_size = _tmp32_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp33_ = 0;
			gint _tmp34_ = 0;
			gint _tmp35_ = 0;
			Document* doc = NULL;
			GeeList* _tmp36_ = NULL;
			gint _tmp37_ = 0;
			gpointer _tmp38_ = NULL;
			gboolean _tmp39_ = FALSE;
			Document* _tmp40_ = NULL;
			gint _tmp41_ = 0;
			gint _tmp42_ = 0;
			Document* _tmp46_ = NULL;
			GFile* _tmp47_ = NULL;
			GFile* _tmp48_ = NULL;
			Project _tmp49_ = {0};
			GFile* _tmp50_ = NULL;
			gboolean _tmp51_ = FALSE;
			_tmp33_ = _doc_index;
			_doc_index = _tmp33_ + 1;
			_tmp34_ = _doc_index;
			_tmp35_ = _doc_size;
			if (!(_tmp34_ < _tmp35_)) {
				break;
			}
			_tmp36_ = _doc_list;
			_tmp37_ = _doc_index;
			_tmp38_ = gee_list_get (_tmp36_, _tmp37_);
			doc = (Document*) _tmp38_;
			_tmp40_ = doc;
			_tmp41_ = document_get_project_id (_tmp40_);
			_tmp42_ = _tmp41_;
			if (_tmp42_ != (-1)) {
				_tmp39_ = TRUE;
			} else {
				Document* _tmp43_ = NULL;
				GFile* _tmp44_ = NULL;
				GFile* _tmp45_ = NULL;
				_tmp43_ = doc;
				_tmp44_ = document_get_location (_tmp43_);
				_tmp45_ = _tmp44_;
				_tmp39_ = _tmp45_ == NULL;
			}
			if (_tmp39_) {
				_g_object_unref0 (doc);
				continue;
			}
			_tmp46_ = doc;
			_tmp47_ = document_get_location (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = *new_project;
			_tmp50_ = _tmp49_.directory;
			_tmp51_ = g_file_has_prefix (_tmp48_, _tmp50_);
			if (_tmp51_) {
				Document* _tmp52_ = NULL;
				GeeLinkedList* _tmp53_ = NULL;
				gint _tmp54_ = 0;
				gint _tmp55_ = 0;
				_tmp52_ = doc;
				_tmp53_ = self->priv->projects;
				_tmp54_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp53_);
				_tmp55_ = _tmp54_;
				document_set_project_id (_tmp52_, _tmp55_ - 1);
			}
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	projects_update_all_menus (self);
	result = TRUE;
	_g_object_unref0 (docs);
	if (conflict_file) {
		*conflict_file = _vala_conflict_file;
	} else {
		_g_object_unref0 (_vala_conflict_file);
	}
	return result;
}


gboolean projects_change_main_file (Projects* self, gint num, GFile* new_main_file) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	Project project = {0};
	GeeLinkedList* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gpointer _tmp8_ = NULL;
	Project* _tmp9_ = NULL;
	Project _tmp10_ = {0};
	Project _tmp11_ = {0};
	GFile* _tmp12_ = NULL;
	Project _tmp13_ = {0};
	GFile* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	GFile* _tmp16_ = NULL;
	Project _tmp17_ = {0};
	GFile* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	GFile* _tmp20_ = NULL;
	GFile* _tmp21_ = NULL;
	GeeLinkedList* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	Project _tmp24_ = {0};
	GeeList* docs = NULL;
	LatexilaApp* _tmp25_ = NULL;
	LatexilaApp* _tmp26_ = NULL;
	GeeList* _tmp27_ = NULL;
	GeeList* _tmp28_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (new_main_file != NULL, FALSE);
	_tmp1_ = num;
	if (_tmp1_ >= 0) {
		gint _tmp2_ = 0;
		GeeLinkedList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp2_ = num;
		_tmp3_ = self->priv->projects;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp2_ < _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_val_if_fail (_tmp0_, FALSE);
	_tmp6_ = self->priv->projects;
	_tmp7_ = num;
	_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _tmp7_);
	_tmp9_ = (Project*) _tmp8_;
	project_copy (_tmp9_, &_tmp10_);
	_tmp11_ = _tmp10_;
	_project_free0 (_tmp9_);
	project = _tmp11_;
	_tmp12_ = new_main_file;
	_tmp13_ = project;
	_tmp14_ = _tmp13_.main_file;
	_tmp15_ = g_file_equal (_tmp12_, _tmp14_);
	if (_tmp15_) {
		result = FALSE;
		project_destroy (&project);
		return result;
	}
	_tmp16_ = new_main_file;
	_tmp17_ = project;
	_tmp18_ = _tmp17_.directory;
	_tmp19_ = g_file_has_prefix (_tmp16_, _tmp18_);
	g_return_val_if_fail (_tmp19_, FALSE);
	_tmp20_ = new_main_file;
	_tmp21_ = _g_object_ref0 (_tmp20_);
	_g_object_unref0 (project.main_file);
	project.main_file = _tmp21_;
	_tmp22_ = self->priv->projects;
	_tmp23_ = num;
	_tmp24_ = project;
	gee_abstract_list_set ((GeeAbstractList*) _tmp22_, _tmp23_, &_tmp24_);
	self->priv->modified = TRUE;
	_tmp25_ = latexila_app_get_instance ();
	_tmp26_ = _tmp25_;
	_tmp27_ = latexila_app_get_documents (_tmp26_);
	_tmp28_ = _tmp27_;
	_g_object_unref0 (_tmp26_);
	docs = _tmp28_;
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp29_ = NULL;
		GeeList* _tmp30_ = NULL;
		gint _doc_size = 0;
		GeeList* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		gint _doc_index = 0;
		_tmp29_ = docs;
		_tmp30_ = _g_object_ref0 (_tmp29_);
		_doc_list = _tmp30_;
		_tmp31_ = _doc_list;
		_tmp32_ = gee_collection_get_size ((GeeCollection*) _tmp31_);
		_tmp33_ = _tmp32_;
		_doc_size = _tmp33_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp34_ = 0;
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
			Document* doc = NULL;
			GeeList* _tmp37_ = NULL;
			gint _tmp38_ = 0;
			gpointer _tmp39_ = NULL;
			Document* _tmp40_ = NULL;
			gint _tmp41_ = 0;
			gint _tmp42_ = 0;
			gint _tmp43_ = 0;
			_tmp34_ = _doc_index;
			_doc_index = _tmp34_ + 1;
			_tmp35_ = _doc_index;
			_tmp36_ = _doc_size;
			if (!(_tmp35_ < _tmp36_)) {
				break;
			}
			_tmp37_ = _doc_list;
			_tmp38_ = _doc_index;
			_tmp39_ = gee_list_get (_tmp37_, _tmp38_);
			doc = (Document*) _tmp39_;
			_tmp40_ = doc;
			_tmp41_ = document_get_project_id (_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = num;
			if (_tmp42_ == _tmp43_) {
				Document* _tmp44_ = NULL;
				gint _tmp45_ = 0;
				_tmp44_ = doc;
				_tmp45_ = num;
				document_set_project_id (_tmp44_, _tmp45_);
			}
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	result = TRUE;
	_g_object_unref0 (docs);
	project_destroy (&project);
	return result;
}


void projects_delete (Projects* self, gint num) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	GeeLinkedList* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gpointer _tmp8_ = NULL;
	Project* _tmp9_ = NULL;
	GeeList* docs = NULL;
	LatexilaApp* _tmp10_ = NULL;
	LatexilaApp* _tmp11_ = NULL;
	GeeList* _tmp12_ = NULL;
	GeeList* _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = num;
	if (_tmp1_ >= 0) {
		gint _tmp2_ = 0;
		GeeLinkedList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp2_ = num;
		_tmp3_ = self->priv->projects;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp2_ < _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_if_fail (_tmp0_);
	_tmp6_ = self->priv->projects;
	_tmp7_ = num;
	_tmp8_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp6_, _tmp7_);
	_tmp9_ = (Project*) _tmp8_;
	_project_free0 (_tmp9_);
	self->priv->modified = TRUE;
	_tmp10_ = latexila_app_get_instance ();
	_tmp11_ = _tmp10_;
	_tmp12_ = latexila_app_get_documents (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp11_);
	docs = _tmp13_;
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp14_ = NULL;
		GeeList* _tmp15_ = NULL;
		gint _doc_size = 0;
		GeeList* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gint _doc_index = 0;
		_tmp14_ = docs;
		_tmp15_ = _g_object_ref0 (_tmp14_);
		_doc_list = _tmp15_;
		_tmp16_ = _doc_list;
		_tmp17_ = gee_collection_get_size ((GeeCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_doc_size = _tmp18_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			Document* doc = NULL;
			GeeList* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gpointer _tmp24_ = NULL;
			Document* _tmp25_ = NULL;
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			_tmp19_ = _doc_index;
			_doc_index = _tmp19_ + 1;
			_tmp20_ = _doc_index;
			_tmp21_ = _doc_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _doc_list;
			_tmp23_ = _doc_index;
			_tmp24_ = gee_list_get (_tmp22_, _tmp23_);
			doc = (Document*) _tmp24_;
			_tmp25_ = doc;
			_tmp26_ = document_get_project_id (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = num;
			if (_tmp27_ == _tmp28_) {
				Document* _tmp29_ = NULL;
				_tmp29_ = doc;
				document_set_project_id (_tmp29_, -1);
			} else {
				Document* _tmp30_ = NULL;
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				gint _tmp33_ = 0;
				_tmp30_ = doc;
				_tmp31_ = document_get_project_id (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = num;
				if (_tmp32_ > _tmp33_) {
					Document* _tmp34_ = NULL;
					gint _tmp35_ = 0;
					gint _tmp36_ = 0;
					_tmp34_ = doc;
					_tmp35_ = document_get_project_id (_tmp34_);
					_tmp36_ = _tmp35_;
					document_set_project_id (_tmp34_, _tmp36_ - 1);
				}
			}
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	projects_update_all_menus (self);
	_g_object_unref0 (docs);
}


void projects_clear_all (Projects* self) {
	GeeLinkedList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->projects;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	self->priv->modified = TRUE;
	projects_update_all_documents (self);
	projects_update_all_menus (self);
}


static void projects_update_all_documents (Projects* self) {
	GeeList* docs = NULL;
	LatexilaApp* _tmp0_ = NULL;
	LatexilaApp* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = latexila_app_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = latexila_app_get_documents (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	docs = _tmp3_;
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp4_ = NULL;
		GeeList* _tmp5_ = NULL;
		gint _doc_size = 0;
		GeeList* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _doc_index = 0;
		_tmp4_ = docs;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_doc_list = _tmp5_;
		_tmp6_ = _doc_list;
		_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_doc_size = _tmp8_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			Document* doc = NULL;
			GeeList* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gpointer _tmp14_ = NULL;
			Document* _tmp15_ = NULL;
			Document* _tmp16_ = NULL;
			GFile* _tmp17_ = NULL;
			GFile* _tmp18_ = NULL;
			_tmp9_ = _doc_index;
			_doc_index = _tmp9_ + 1;
			_tmp10_ = _doc_index;
			_tmp11_ = _doc_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _doc_list;
			_tmp13_ = _doc_index;
			_tmp14_ = gee_list_get (_tmp12_, _tmp13_);
			doc = (Document*) _tmp14_;
			_tmp15_ = doc;
			document_set_project_id (_tmp15_, -1);
			_tmp16_ = doc;
			_tmp17_ = document_get_location (_tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_ == NULL) {
				_g_object_unref0 (doc);
				continue;
			}
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp19_ = FALSE;
					_tmp19_ = TRUE;
					while (TRUE) {
						gint _tmp21_ = 0;
						GeeLinkedList* _tmp22_ = NULL;
						gint _tmp23_ = 0;
						gint _tmp24_ = 0;
						Document* _tmp25_ = NULL;
						GFile* _tmp26_ = NULL;
						GFile* _tmp27_ = NULL;
						GeeLinkedList* _tmp28_ = NULL;
						gint _tmp29_ = 0;
						gpointer _tmp30_ = NULL;
						Project* _tmp31_ = NULL;
						GFile* _tmp32_ = NULL;
						gboolean _tmp33_ = FALSE;
						gboolean _tmp34_ = FALSE;
						if (!_tmp19_) {
							gint _tmp20_ = 0;
							_tmp20_ = i;
							i = _tmp20_ + 1;
						}
						_tmp19_ = FALSE;
						_tmp21_ = i;
						_tmp22_ = self->priv->projects;
						_tmp23_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp22_);
						_tmp24_ = _tmp23_;
						if (!(_tmp21_ < _tmp24_)) {
							break;
						}
						_tmp25_ = doc;
						_tmp26_ = document_get_location (_tmp25_);
						_tmp27_ = _tmp26_;
						_tmp28_ = self->priv->projects;
						_tmp29_ = i;
						_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _tmp29_);
						_tmp31_ = (Project*) _tmp30_;
						_tmp32_ = (*_tmp31_).directory;
						_tmp33_ = g_file_has_prefix (_tmp27_, _tmp32_);
						_tmp34_ = _tmp33_;
						_project_free0 (_tmp31_);
						if (_tmp34_) {
							Document* _tmp35_ = NULL;
							gint _tmp36_ = 0;
							_tmp35_ = doc;
							_tmp36_ = i;
							document_set_project_id (_tmp35_, _tmp36_);
							break;
						}
					}
				}
			}
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	_g_object_unref0 (docs);
}


static void projects_parser_start (Projects* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("projects")))) {
		switch (0) {
			default:
			{
				return;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("project")))) {
		switch (0) {
			default:
			{
				Project project = {0};
				GeeLinkedList* _tmp31_ = NULL;
				Project _tmp32_ = {0};
				memset (&project, 0, sizeof (Project));
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_ = 0;
							gchar** _tmp7_ = NULL;
							gint _tmp7__length1 = 0;
							gchar** _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp9_ = 0;
							const gchar* _tmp10_ = NULL;
							const gchar* _tmp11_ = NULL;
							GQuark _tmp13_ = 0U;
							static GQuark _tmp12_label0 = 0;
							static GQuark _tmp12_label1 = 0;
							if (!_tmp4_) {
								gint _tmp5_ = 0;
								_tmp5_ = i;
								i = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = i;
							_tmp7_ = attr_names;
							_tmp7__length1 = attr_names_length1;
							if (!(_tmp6_ < _tmp7__length1)) {
								break;
							}
							_tmp8_ = attr_names;
							_tmp8__length1 = attr_names_length1;
							_tmp9_ = i;
							_tmp10_ = _tmp8_[_tmp9_];
							_tmp11_ = _tmp10_;
							_tmp13_ = (NULL == _tmp11_) ? 0 : g_quark_from_string (_tmp11_);
							if (_tmp13_ == ((0 != _tmp12_label0) ? _tmp12_label0 : (_tmp12_label0 = g_quark_from_static_string ("directory")))) {
								switch (0) {
									default:
									{
										gchar** _tmp14_ = NULL;
										gint _tmp14__length1 = 0;
										gint _tmp15_ = 0;
										const gchar* _tmp16_ = NULL;
										GFile* _tmp17_ = NULL;
										_tmp14_ = attr_values;
										_tmp14__length1 = attr_values_length1;
										_tmp15_ = i;
										_tmp16_ = _tmp14_[_tmp15_];
										_tmp17_ = g_file_new_for_uri (_tmp16_);
										_g_object_unref0 (project.directory);
										project.directory = _tmp17_;
										break;
									}
								}
							} else if (_tmp13_ == ((0 != _tmp12_label1) ? _tmp12_label1 : (_tmp12_label1 = g_quark_from_static_string ("main_file")))) {
								switch (0) {
									default:
									{
										gchar** _tmp18_ = NULL;
										gint _tmp18__length1 = 0;
										gint _tmp19_ = 0;
										const gchar* _tmp20_ = NULL;
										GFile* _tmp21_ = NULL;
										_tmp18_ = attr_values;
										_tmp18__length1 = attr_values_length1;
										_tmp19_ = i;
										_tmp20_ = _tmp18_[_tmp19_];
										_tmp21_ = g_file_new_for_uri (_tmp20_);
										_g_object_unref0 (project.main_file);
										project.main_file = _tmp21_;
										break;
									}
								}
							} else {
								switch (0) {
									default:
									{
										gchar** _tmp22_ = NULL;
										gint _tmp22__length1 = 0;
										gint _tmp23_ = 0;
										const gchar* _tmp24_ = NULL;
										gchar* _tmp25_ = NULL;
										gchar* _tmp26_ = NULL;
										gchar* _tmp27_ = NULL;
										gchar* _tmp28_ = NULL;
										GError* _tmp29_ = NULL;
										GError* _tmp30_ = NULL;
										_tmp22_ = attr_names;
										_tmp22__length1 = attr_names_length1;
										_tmp23_ = i;
										_tmp24_ = _tmp22_[_tmp23_];
										_tmp25_ = g_strconcat ("unknown attribute \"", _tmp24_, NULL);
										_tmp26_ = _tmp25_;
										_tmp27_ = g_strconcat (_tmp26_, "\"", NULL);
										_tmp28_ = _tmp27_;
										_tmp29_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp28_);
										_tmp30_ = _tmp29_;
										_g_free0 (_tmp28_);
										_g_free0 (_tmp26_);
										_inner_error_ = _tmp30_;
										if (_inner_error_->domain == G_MARKUP_ERROR) {
											g_propagate_error (error, _inner_error_);
											project_destroy (&project);
											return;
										} else {
											project_destroy (&project);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
								}
							}
						}
					}
				}
				_tmp31_ = self->priv->projects;
				_tmp32_ = project;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp31_, &_tmp32_);
				project_destroy (&project);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp33_ = NULL;
				gchar* _tmp34_ = NULL;
				gchar* _tmp35_ = NULL;
				gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				GError* _tmp38_ = NULL;
				GError* _tmp39_ = NULL;
				_tmp33_ = name;
				_tmp34_ = g_strconcat ("unknown element \"", _tmp33_, NULL);
				_tmp35_ = _tmp34_;
				_tmp36_ = g_strconcat (_tmp35_, "\"", NULL);
				_tmp37_ = _tmp36_;
				_tmp38_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp37_);
				_tmp39_ = _tmp38_;
				_g_free0 (_tmp37_);
				_g_free0 (_tmp35_);
				_inner_error_ = _tmp39_;
				if (_inner_error_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static GFile* projects_get_xml_file (Projects* self) {
	GFile* result = NULL;
	gchar* path = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "latexila", "projects.xml", NULL, NULL);
	path = _tmp1_;
	_tmp2_ = g_file_new_for_path (path);
	result = _tmp2_;
	_g_free0 (path);
	return result;
}


void projects_save (Projects* self) {
	gboolean _tmp0_ = FALSE;
	GFile* file = NULL;
	GFile* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gchar* content = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	GFile* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->modified;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = projects_get_xml_file (self);
	file = _tmp1_;
	_tmp2_ = self->priv->projects;
	_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		GFile* _tmp5_ = NULL;
		_tmp5_ = file;
		utils_delete_file (_tmp5_);
		_g_object_unref0 (file);
		return;
	}
	_tmp6_ = g_strdup ("<projects>\n");
	content = _tmp6_;
	{
		GeeLinkedList* _project_list = NULL;
		GeeLinkedList* _tmp7_ = NULL;
		GeeLinkedList* _tmp8_ = NULL;
		gint _project_size = 0;
		GeeLinkedList* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _project_index = 0;
		_tmp7_ = self->priv->projects;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_project_list = _tmp8_;
		_tmp9_ = _project_list;
		_tmp10_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_project_size = _tmp11_;
		_project_index = -1;
		while (TRUE) {
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			Project project = {0};
			GeeLinkedList* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			gpointer _tmp17_ = NULL;
			Project* _tmp18_ = NULL;
			Project _tmp19_ = {0};
			Project _tmp20_ = {0};
			const gchar* _tmp21_ = NULL;
			Project _tmp22_ = {0};
			GFile* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			Project _tmp26_ = {0};
			GFile* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_ = NULL;
			_tmp12_ = _project_index;
			_project_index = _tmp12_ + 1;
			_tmp13_ = _project_index;
			_tmp14_ = _project_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _project_list;
			_tmp16_ = _project_index;
			_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _tmp16_);
			_tmp18_ = (Project*) _tmp17_;
			project_copy (_tmp18_, &_tmp19_);
			_tmp20_ = _tmp19_;
			_project_free0 (_tmp18_);
			project = _tmp20_;
			_tmp21_ = content;
			_tmp22_ = project;
			_tmp23_ = _tmp22_.directory;
			_tmp24_ = g_file_get_uri (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = project;
			_tmp27_ = _tmp26_.main_file;
			_tmp28_ = g_file_get_uri (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_strdup_printf ("  <project directory=\"%s\" main_file=\"%s\" />\n", _tmp25_, _tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_strconcat (_tmp21_, _tmp31_, NULL);
			_g_free0 (content);
			content = _tmp32_;
			_g_free0 (_tmp31_);
			_g_free0 (_tmp29_);
			_g_free0 (_tmp25_);
			project_destroy (&project);
		}
		_g_object_unref0 (_project_list);
	}
	_tmp33_ = content;
	_tmp34_ = g_strconcat (_tmp33_, "</projects>\n", NULL);
	_g_free0 (content);
	content = _tmp34_;
	_tmp35_ = file;
	_tmp36_ = content;
	utils_save_file (_tmp35_, _tmp36_, FALSE);
	_g_free0 (content);
	_g_object_unref0 (file);
}


static gboolean projects_conflict (Projects* self, GFile* dir1, GFile* dir2) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dir1 != NULL, FALSE);
	g_return_val_if_fail (dir2 != NULL, FALSE);
	_tmp2_ = dir1;
	_tmp3_ = dir2;
	_tmp4_ = g_file_has_prefix (_tmp2_, _tmp3_);
	if (_tmp4_) {
		_tmp1_ = TRUE;
	} else {
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp5_ = dir2;
		_tmp6_ = dir1;
		_tmp7_ = g_file_has_prefix (_tmp5_, _tmp6_);
		_tmp1_ = _tmp7_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		GFile* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp8_ = dir1;
		_tmp9_ = dir2;
		_tmp10_ = g_file_equal (_tmp8_, _tmp9_);
		_tmp0_ = _tmp10_;
	}
	result = _tmp0_;
	return result;
}


static void value_projects_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_projects_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		projects_unref (value->data[0].v_pointer);
	}
}


static void value_projects_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = projects_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_projects_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_projects_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Projects* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = projects_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_projects_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Projects** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = projects_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_projects (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecProjects* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PROJECTS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_projects (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROJECTS), NULL);
	return value->data[0].v_pointer;
}


void value_set_projects (GValue* value, gpointer v_object) {
	Projects* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROJECTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PROJECTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		projects_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		projects_unref (old);
	}
}


void value_take_projects (GValue* value, gpointer v_object) {
	Projects* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROJECTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PROJECTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		projects_unref (old);
	}
}


static void projects_class_init (ProjectsClass * klass) {
	projects_parent_class = g_type_class_peek_parent (klass);
	((ProjectsClass *) klass)->finalize = projects_finalize;
	g_type_class_add_private (klass, sizeof (ProjectsPrivate));
}


static void projects_instance_init (Projects * self) {
	self->priv = PROJECTS_GET_PRIVATE (self);
	self->priv->modified = FALSE;
	self->ref_count = 1;
}


static void projects_finalize (Projects* obj) {
	Projects * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROJECTS, Projects);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->projects);
}


GType projects_get_type (void) {
	static volatile gsize projects_type_id__volatile = 0;
	if (g_once_init_enter (&projects_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_projects_init, value_projects_free_value, value_projects_copy_value, value_projects_peek_pointer, "p", value_projects_collect_value, "p", value_projects_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ProjectsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) projects_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Projects), 0, (GInstanceInitFunc) projects_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType projects_type_id;
		projects_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Projects", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&projects_type_id__volatile, projects_type_id);
	}
	return projects_type_id__volatile;
}


gpointer projects_ref (gpointer instance) {
	Projects* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void projects_unref (gpointer instance) {
	Projects* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PROJECTS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



