/* -*- mode: c; c-basic-offset: 2; indent-tabs-mode: nil; -*- */
/* geoclue-stumbler-settings.h
 *
 * Copyright 2021 Chris Talbot <chris@talbothome.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author(s):
 *   Chris Talbot <chris@talbothome.com>
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <adwaita.h>

G_BEGIN_DECLS

#define GEOCLUE_STUMBLER_TYPE_SETTINGS (geoclue_stumbler_settings_get_type ())

G_DECLARE_FINAL_TYPE (GeoclueStumblerSettings, geoclue_stumbler_settings, GEOCLUESTUMBLER, SETTINGS, GObject)

GeoclueStumblerSettings *geoclue_stumbler_settings_get_default            (void);

char *geoclue_stumbler_settings_get_submission_url (GeoclueStumblerSettings *self);
void  geoclue_stumbler_settings_set_submission_url (GeoclueStumblerSettings *self,
                                                    const char  *submission_url);

int  geoclue_stumbler_settings_get_total_number_of_submissions (GeoclueStumblerSettings *self);
void geoclue_stumbler_settings_set_total_number_of_submissions (GeoclueStumblerSettings *self,
                                                                int  number_of_submissions);
void geoclue_stumbler_settings_add_total_number_of_submissions (GeoclueStumblerSettings *self,
                                                                int  number_of_submissions);

gboolean geoclue_stumbler_settings_get_show_submission_location (GeoclueStumblerSettings *self);
void     geoclue_stumbler_settings_set_show_submission_location (GeoclueStumblerSettings *self,
                                                                 gboolean     show_submission_location);


G_END_DECLS
