"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MathTableIo = void 0;
const errors_1 = require("@ot-builder/errors");
const ot_layout_1 = require("@ot-builder/ot-layout");
const constants_1 = require("./constants");
const glyph_info_1 = require("./glyph-info");
const variants_1 = require("./variants");
exports.MathTableIo = {
    read(bv, gOrd) {
        const majorVersion = bv.uint16();
        const minorVersion = bv.uint16();
        errors_1.Assert.SubVersionSupported("MathTable", majorVersion, minorVersion, [1, 0]);
        const mathConstants = bv.next(constants_1.Ptr16MathConstantsNullable);
        const mathGlyphInfo = bv.next(glyph_info_1.Ptr16MathGlyphInfoNullable, gOrd);
        const mathVariants = bv.next(variants_1.Ptr16MathVariantsNullable, gOrd);
        return new ot_layout_1.Math.Table(mathConstants, mathGlyphInfo, mathVariants);
    },
    write(fr, math, gOrd) {
        fr.uint16(1).uint16(0);
        fr.push(constants_1.Ptr16MathConstantsNullable, math.constants);
        fr.push(glyph_info_1.Ptr16MathGlyphInfoNullable, math.glyphInfo, gOrd);
        fr.push(variants_1.Ptr16MathVariantsNullable, math.variants, gOrd);
    }
};
//# sourceMappingURL=index.js.map