"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ptr16BaseCoordNullable = exports.Ptr16BaseCoord = exports.BaseCoord = void 0;
const bin_composite_types_1 = require("@ot-builder/bin-composite-types");
const ImpLib = require("@ot-builder/common-impl");
const errors_1 = require("@ot-builder/errors");
const variance_1 = require("@ot-builder/variance");
const device_table_1 = require("../shared/device-table");
function anchorNeedsFormat3(a) {
    return !variance_1.OtVar.Ops.isConstant(a.at) || a.deviceDeltas;
}
exports.BaseCoord = {
    read(bp, gOrd, ivs) {
        const format = bp.uint16();
        switch (format) {
            case 1:
                return { at: bp.int16() };
            case 2:
                return {
                    at: bp.int16(),
                    pointAttachment: { glyph: gOrd.at(bp.uint16()), pointIndex: bp.uint16() }
                };
            case 3: {
                const atOrig = bp.int16();
                const atDD = bp.next(device_table_1.Ptr16DeviceTable, ivs);
                return {
                    at: variance_1.OtVar.Ops.add(atOrig, atDD ? atDD.variation : 0),
                    deviceDeltas: atDD ? atDD.deviceDeltas : null
                };
            }
            default:
                throw errors_1.Errors.FormatNotSupported("BaseCoord", format);
        }
    },
    write(bb, a, gOrd, ivs) {
        if (a.pointAttachment) {
            bb.uint16(2);
            bb.int16(ImpLib.Arith.Round.Coord(variance_1.OtVar.Ops.originOf(a.at)));
            bb.uint16(gOrd.reverse(a.pointAttachment.glyph));
            bb.uint16(a.pointAttachment.pointIndex);
        }
        else if (anchorNeedsFormat3(a)) {
            const dtAt = { variation: a.at, deviceDeltas: a.deviceDeltas };
            bb.uint16(3);
            bb.int16(ImpLib.Arith.Round.Coord(variance_1.OtVar.Ops.originOf(a.at)));
            bb.push(device_table_1.Ptr16DeviceTable, dtAt, ivs);
        }
        else {
            bb.uint16(1);
            bb.int16(ImpLib.Arith.Round.Coord(variance_1.OtVar.Ops.originOf(a.at)));
        }
    }
};
exports.Ptr16BaseCoord = (0, bin_composite_types_1.NonNullablePtr16)(exports.BaseCoord);
exports.Ptr16BaseCoordNullable = (0, bin_composite_types_1.NullablePtr16)(exports.BaseCoord);
//# sourceMappingURL=coord.js.map