! (C) Copyright 2005- ECMWF.
! (C) Copyright 2013- Meteo-France.
! 
! This software is licensed under the terms of the Apache Licence Version 2.0
! which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
! In applying this licence, ECMWF does not waive the privileges and immunities
! granted to it by virtue of its status as an intergovernmental organisation
! nor does it submit to any jurisdiction.
!

SUBROUTINE GSTATS_SETUP( KPROC,KMYPROC,KPRCIDS,&
 & LDSTATS,LDSTATSCPU,LDSYNCSTATS,LDDETAILED_STATS,LDBARRIER_STATS,LDBARRIER_STATS2,&
 & LDSTATS_OMP,LDSTATS_COMMS,LDSTATS_MEM,KSTATS_MEM,LDSTATS_ALLOC,&
 & LDTRACE_STATS,KTRACE_STATS,KPRNT_STATS,LDXML_STATS)

!**** *GSTATS_SETUP*  - Setup stats package

!     PURPOSE.  
!     --------
!      Setup gstats package


!**   INTERFACE.
!     ----------
!       *CALL* *GSTATS_SETUP

!        EXPLICIT ARGUMENTS   None
!        --------------------

!        IMPLICIT ARGUMENTS
!        --------------------
!        Module YOMSTATS

!     METHOD.
!     -------


!     EXTERNALS.   USER_CLOCK - timing routine
!     ----------

!     REFERENCE.
!     ----------
!        ECMWF Research Department documentation of the IFS

!     AUTHOR.
!     -------
!        Mats Hamrud ECMWF

!     MODIFICATIONS.
!     --------------
!        ORIGINAL : 98-11-15
!        I. Hadade  19-05-20  Removed LDSTATS_MPL as not used and enabled collection
!                             of MPL send/recv statistics if LDETAILED_STATS is true
!                             rather than LBARRIER_STATS
!     ------------------------------------------------------------------

USE EC_PARKIND, ONLY: JPIM, JPRD
USE YOMGSTATS, ONLY: LSTATS, LSTATSCPU, LSYNCSTATS, LDETAILED_STATS, LBARRIER_STATS, &
  &                  LBARRIER_STATS2, LXML_STATS, LSTATS_OMP, LSTATS_COMMS, NSTATS_MEM, &
  &                  LSTATS_MEM, LSTATS_ALLOC, LTRACE_STATS, NTRACE_STATS, MYPROC_STATS, &
  &                  NPROC_STATS, NPRCIDS_STATS, NCALL_TRACE, TIME_TRACE, LSTATS_MPL, NUMSEND, &
  &                  NUMRECV, SENDBYTES, RECVBYTES, UNKNOWN_NUMSEND, UNKNOWN_NUMRECV, &
  &                  UNKNOWN_SENDBYTES, UNKNOWN_RECVBYTES, NPRNT_STATS
USE MPL_STATS_MOD, ONLY: MPL_STATSINIT

IMPLICIT NONE

LOGICAL :: LDSTATS
LOGICAL :: LDSTATSCPU
LOGICAL :: LDSYNCSTATS
LOGICAL :: LDDETAILED_STATS
LOGICAL :: LDBARRIER_STATS
LOGICAL :: LDBARRIER_STATS2
LOGICAL :: LDSTATS_OMP
LOGICAL :: LDSTATS_COMMS
LOGICAL :: LDTRACE_STATS
INTEGER(KIND=JPIM) :: KTRACE_STATS
INTEGER(KIND=JPIM) :: KPROC,KMYPROC
INTEGER(KIND=JPIM) :: KPRCIDS(KPROC)
INTEGER(KIND=JPIM) :: KSTATS_MEM
INTEGER(KIND=JPIM) :: KPRNT_STATS
LOGICAL :: LDSTATS_MEM
LOGICAL :: LDSTATS_ALLOC
LOGICAL :: LDXML_STATS
!     ------------------------------------------------------------------

LSTATS = LDSTATS
LSTATSCPU = LDSTATSCPU
LSYNCSTATS = LDSYNCSTATS
LDETAILED_STATS=LDDETAILED_STATS
LBARRIER_STATS=LDBARRIER_STATS
LBARRIER_STATS2=LDBARRIER_STATS2
LXML_STATS=LDXML_STATS
LSTATS_OMP = LDSTATS_OMP
LSTATS_COMMS = LDSTATS_COMMS
NSTATS_MEM = KSTATS_MEM
LSTATS_MEM = LDSTATS_MEM
LSTATS_ALLOC = LDSTATS_ALLOC
LTRACE_STATS = LDTRACE_STATS
IF (LTRACE_STATS) NTRACE_STATS = KTRACE_STATS

MYPROC_STATS = KMYPROC
NPROC_STATS  = KPROC
ALLOCATE(NPRCIDS_STATS(NPROC_STATS))
NPRCIDS_STATS(:) = KPRCIDS(1:NPROC_STATS)
IF (NPROC_STATS == 1) LSYNCSTATS = .FALSE.

IF (LTRACE_STATS .AND. NTRACE_STATS > 0) THEN
  ALLOCATE(NCALL_TRACE(NTRACE_STATS))
  ALLOCATE(TIME_TRACE (NTRACE_STATS))
  NCALL_TRACE(:) = 0
  TIME_TRACE (:) = 0.0_JPRD
ENDIF


IF (LDETAILED_STATS) THEN
  LSTATS_MPL = .TRUE.
  ALLOCATE(NUMSEND(501:1000))
  ALLOCATE(NUMRECV(501:1000))
  ALLOCATE(SENDBYTES(501:1000))
  ALLOCATE(RECVBYTES(501:1000))
  ALLOCATE(UNKNOWN_NUMSEND(501:1000))
  ALLOCATE(UNKNOWN_NUMRECV(501:1000))
  ALLOCATE(UNKNOWN_SENDBYTES(501:1000))
  ALLOCATE(UNKNOWN_RECVBYTES(501:1000))
  NUMSEND(:) = 0
  NUMRECV(:) = 0
  SENDBYTES(:) = 0
  RECVBYTES(:) = 0
  UNKNOWN_NUMSEND(:) = 0
  UNKNOWN_NUMRECV(:) = 0
  UNKNOWN_SENDBYTES(:) = 0
  UNKNOWN_RECVBYTES(:) = 0
  CALL MPL_STATSINIT
ENDIF

NPRNT_STATS = KPRNT_STATS

END SUBROUTINE GSTATS_SETUP
