complete -c monero-wallet-cli -f

complete -c monero-wallet-cli -l help -d "Produce help message"
complete -c monero-wallet-cli -l version -d "Output version information"
complete -c monero-wallet-cli -l daemon-address -r -d "Use daemon instance at <host>:<port>"
complete -c monero-wallet-cli -l daemon-host -r -d "Use daemon instance at host <arg> instead of localhost"
complete -c monero-wallet-cli -l proxy -r -d "[<ip>:]<port> socks proxy to use for daemon connections"
complete -c monero-wallet-cli -l trusted-daemon -d "Enable commands which rely on a trusted"
complete -c monero-wallet-cli -l untrusted-daemon -d "Disable⋅commands⋅which⋅rely⋅on⋅a trusted daemon"
complete -c monero-wallet-cli -l password -r -d "Wallet⋅password⋅(escape/quote⋅as needed)"
complete -c monero-wallet-cli -l password-file -r -F -d "Wallet⋅password⋅file"
complete -c monero-wallet-cli -l daemon-port -r -d "Use daemon instance at port <arg> instead of 18081"
complete -c monero-wallet-cli -l daemon-login -r -d "Specify username[:password] for daemon RPC client"
complete -c monero-wallet-cli -l daemon-ssl -x -a "enabled disabled autodetect" -d "Enable SSL on daemon RPC connections. Default: autodetect"
complete -c monero-wallet-cli -l daemon-ssl-private-key -r -k -a "(__fish_complete_suffix .pem)" -d "Path to a PEM format private key"
complete -c monero-wallet-cli -l daemon-ssl-certificate -r -k -a "(__fish_complete_suffix .pem)" -d "Path to a PEM format certificate"
complete -c monero-wallet-cli -l daemon-ssl-ca-certificates -r -F -d "Path to file containing concatenated PEM format certificate(s) to replace system CA(s)."
complete -c monero-wallet-cli -l daemon-ssl-allowed-fingerprints -r -d "List of valid fingerprints of allowed RPC servers"
complete -c monero-wallet-cli -l daemon-ssl-allow-any-cert -d "Allow any SSL certificate from the daemon"
complete -c monero-wallet-cli -l daemon-ssl-allow-chained -d "Allow user (via --daemon-ssl-ca-certifi cates) chain certificates"
complete -c monero-wallet-cli -l testnet -d "For testnet. Daemon must also be launched with --testnet flag"
complete -c monero-wallet-cli -l stagenet -d "For stagenet. Daemon must also be launched with --stagenet flag"
complete -c monero-wallet-cli -l shared-ringdb-dir -r -F -d "Set shared ring database path"
complete -c monero-wallet-cli -l kdf-rounds -r -d "Number of rounds for the key derivation function. Default: 1"
complete -c monero-wallet-cli -l bitmessage-address -r -d "Use PyBitmessage instance at URL <arg>. Default: http://localhost:8442/"
complete -c monero-wallet-cli -l bitmessage-login -r -d "Specify <arg> as username:password for PyBitmessage API. Default: username:password"
complete -c monero-wallet-cli -l hw-device -r -d "HW device to use"
complete -c monero-wallet-cli -l hw-device-deriv-path -r -d "HW device wallet derivation path (e.g., SLIP-10)"
complete -c monero-wallet-cli -l tx-notify -r -d "Run a program for each new incoming transaction, '%s' will be replaced by the transaction hash"
complete -c monero-wallet-cli -l no-dns -d "Do not use DNS"
complete -c monero-wallet-cli -l offline -d "Do not connect to a daemon, nor use DNS"
complete -c monero-wallet-cli -l extra-entropy -r -F -d "File containing extra entropy to initialize the PRNG (any data, aim for 256 bits of entropy to be useful, which typically means more than 256 bits of data)"
complete -c monero-wallet-cli -l wallet-file -r -F -d "Use wallet <arg>"
complete -c monero-wallet-cli -l generate-new-wallet -r -F -d "Generate new wallet and save it to <arg>"
complete -c monero-wallet-cli -l generate-from-device -r -F -d "Generate new wallet from device and save it to <arg>"
complete -c monero-wallet-cli -l generate-from-view-key -r -d "Generate incoming-only wallet from view key"
complete -c monero-wallet-cli -l generate-from-spend-key -r -d "Generate deterministic wallet from spend key"
complete -c monero-wallet-cli -l generate-from-keys -r -d "Generate wallet from private keys"
complete -c monero-wallet-cli -l generate-from-multisig-keys -r -d "Generate a master wallet from multisig wallet keys"
complete -c monero-wallet-cli -l generate-from-json -r -k -a "(__fish_complete_suffix .json)" -d "Generate wallet from JSON format file"
complete -c monero-wallet-cli -l mnemonic-language -r -d "Language for mnemonic"
complete -c monero-wallet-cli -l command -d ""
complete -c monero-wallet-cli -l restore-deterministic-wallet -d "Recover wallet using Electrum-style mnemonic seed"
complete -c monero-wallet-cli -l restore-from-seed -d "alias for --restore-deterministic-wallet"
complete -c monero-wallet-cli -l restore-multisig-wallet -d "Recover multisig wallet using Electrum-style mnemonic seed"
complete -c monero-wallet-cli -l non-deterministic -d "Generate non-deterministic view and spend keys"
complete -c monero-wallet-cli -l electrum-seed -r -d "Specify Electrum seed for wallet recovery/creation"
complete -c monero-wallet-cli -l allow-mismatched-daemon-version -d "Allow communicating with a daemon that uses a different RPC version"
complete -c monero-wallet-cli -l restore-height -r -d "Restore from specific blockchain height. Default: 0"
complete -c monero-wallet-cli -l restore-date -r -d "Restore from estimated blockchain height on specified date"
complete -c monero-wallet-cli -l do-not-relay -d "The newly created transaction will not be relayed to the monero network"
complete -c monero-wallet-cli -l create-address-file -d "Create an address file for new wallets"
complete -c monero-wallet-cli -l subaddress-lookahead -r -d "Set subaddress lookahead sizes to <major>:<minor>"
complete -c monero-wallet-cli -l use-english-language-names -d "Display English language names"
complete -c monero-wallet-cli -l rpc-client-secret-key -r -d "Set RPC client secret key for RPC payments"
complete -c monero-wallet-cli -l log-file -r -F -d "Specify log file"
complete -c monero-wallet-cli -l log-level -r -a "0 1 2 3 4" -d "0-4 or categories"
complete -c monero-wallet-cli -l max-log-file-size -r -d "Specify maximum log file size [B]. Default: 104850000"
complete -c monero-wallet-cli -l max-log-files -r -d "Specify maximum number of rotated log files to be saved (no limit by setting to 0). Default: 50"
complete -c monero-wallet-cli -l max-concurrency -d "Max number of threads to use for a parallel job. Default: 1"
complete -c monero-wallet-cli -l config-file -r -F -d "Config file"
