// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file ShapeType.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__SHAPETYPE_HPP
#define FAST_DDS_GENERATED__SHAPETYPE_HPP

#include <cstdint>
#include <string>
#include <utility>
#include <fastcdr/cdr/fixed_size_string.hpp>

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(SHAPETYPE_SOURCE)
#define SHAPETYPE_DllAPI __declspec( dllexport )
#else
#define SHAPETYPE_DllAPI __declspec( dllimport )
#endif // SHAPETYPE_SOURCE
#else
#define SHAPETYPE_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define SHAPETYPE_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure ShapeType defined by the user in the IDL file.
 * @ingroup ShapeType
 */
class ShapeType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ShapeType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ShapeType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ShapeType that will be copied.
     */
    eProsima_user_DllExport ShapeType(
            const ShapeType& x)
    {
                    m_color = x.m_color;

                    m_x = x.m_x;

                    m_y = x.m_y;

                    m_shapesize = x.m_shapesize;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ShapeType that will be copied.
     */
    eProsima_user_DllExport ShapeType(
            ShapeType&& x) noexcept
    {
        m_color = std::move(x.m_color);
        m_x = x.m_x;
        m_y = x.m_y;
        m_shapesize = x.m_shapesize;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ShapeType that will be copied.
     */
    eProsima_user_DllExport ShapeType& operator =(
            const ShapeType& x)
    {

                    m_color = x.m_color;

                    m_x = x.m_x;

                    m_y = x.m_y;

                    m_shapesize = x.m_shapesize;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ShapeType that will be copied.
     */
    eProsima_user_DllExport ShapeType& operator =(
            ShapeType&& x) noexcept
    {

        m_color = std::move(x.m_color);
        m_x = x.m_x;
        m_y = x.m_y;
        m_shapesize = x.m_shapesize;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ShapeType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ShapeType& x) const
    {
        return (m_color == x.m_color &&
           m_x == x.m_x &&
           m_y == x.m_y &&
           m_shapesize == x.m_shapesize);
    }

    /*!
     * @brief Comparison operator.
     * @param x ShapeType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ShapeType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member color
     * @param _color New value to be copied in member color
     */
    eProsima_user_DllExport void color(
            const std::string& _color)
    {
        m_color = _color;
    }

    /*!
     * @brief This function moves the value in member color
     * @param _color New value to be moved in member color
     */
    eProsima_user_DllExport void color(
            std::string&& _color)
    {
        m_color = std::move(_color);
    }

    /*!
     * @brief This function returns a constant reference to member color
     * @return Constant reference to member color
     */
    eProsima_user_DllExport const std::string& color() const
    {
        return m_color;
    }

    /*!
     * @brief This function returns a reference to member color
     * @return Reference to member color
     */
    eProsima_user_DllExport std::string& color()
    {
        return m_color;
    }


    /*!
     * @brief This function sets a value in member x
     * @param _x New value for member x
     */
    eProsima_user_DllExport void x(
            int32_t _x)
    {
        m_x = _x;
    }

    /*!
     * @brief This function returns the value of member x
     * @return Value of member x
     */
    eProsima_user_DllExport int32_t x() const
    {
        return m_x;
    }

    /*!
     * @brief This function returns a reference to member x
     * @return Reference to member x
     */
    eProsima_user_DllExport int32_t& x()
    {
        return m_x;
    }


    /*!
     * @brief This function sets a value in member y
     * @param _y New value for member y
     */
    eProsima_user_DllExport void y(
            int32_t _y)
    {
        m_y = _y;
    }

    /*!
     * @brief This function returns the value of member y
     * @return Value of member y
     */
    eProsima_user_DllExport int32_t y() const
    {
        return m_y;
    }

    /*!
     * @brief This function returns a reference to member y
     * @return Reference to member y
     */
    eProsima_user_DllExport int32_t& y()
    {
        return m_y;
    }


    /*!
     * @brief This function sets a value in member shapesize
     * @param _shapesize New value for member shapesize
     */
    eProsima_user_DllExport void shapesize(
            int32_t _shapesize)
    {
        m_shapesize = _shapesize;
    }

    /*!
     * @brief This function returns the value of member shapesize
     * @return Value of member shapesize
     */
    eProsima_user_DllExport int32_t shapesize() const
    {
        return m_shapesize;
    }

    /*!
     * @brief This function returns a reference to member shapesize
     * @return Reference to member shapesize
     */
    eProsima_user_DllExport int32_t& shapesize()
    {
        return m_shapesize;
    }



private:

    std::string m_color;
    int32_t m_x{0};
    int32_t m_y{0};
    int32_t m_shapesize{0};

};

#endif // _FAST_DDS_GENERATED_SHAPETYPE_HPP_


