# Microsoft.NET.Build.Containers 8.0.300

This version brings the following new features and enhancements:

* The SDK will generate additional container metadata labels now.
  * The `org.opencontainers.image.base.digest` label will be added to uniquely identify the image used as a base for the application container.
  * The `net.dot.runtime.majorminor` label will be added to identify the major and minor version of the .NET Runtime that the application runs against.
  * The `net.dot.sdk.version` label will be added to identify the .NET SDK version used to build the application container.

* The SDK can use and produce OCI base image layers, not just Docker base image layers. This will happen automatically based on the kind of base image digest you use.

* The SDK will automatically use the `-extra` variant of base images when the application needs globalization/ICU support. So if you set `<ContainerFamily>jammy-chiseled</ContainerFamily>` and `<InvariantGlobalization>false</InvariantGlobalization>` in your project file, the SDK will behave as if you set `<ContainerFamily>jammy-chiseled-extra</ContainerFamily>` - this ensures that your application has the required ICU/Globalization support libraries.

* The SDK will use the runtime-deps base images for Trimmed applications, in addition to AOT applications.
