/* SPDX-License-Identifier: GPL-2.0 OR BSD-3-Clause */
/*
 * Copyright (C) 2013-2015, 2018-2025 Intel Corporation
 * Copyright (C) 2013-2015 Intel Mobile Communications GmbH
 */
#if !defined(__IWL_DBG_CFG_H__) || defined(DBG_CFG_REINCLUDE)
#undef __IWL_DBG_CFG_H__ /* avoid warning */
#define __IWL_DBG_CFG_H__
/*
 * with DBG_CFG_REINCLUDE set this file should contain nothing
 * but IWL_DBG_CFG() macro invocations so it can be used in
 * the C file to generate more code (e.g. for debugfs and the
 * struct initialization with default values)
 */
#ifndef DBG_CFG_REINCLUDE
#include <linux/types.h>

struct iwl_dbg_cfg_bin {
	const void *data;
	unsigned int len;
};

struct iwl_dbg_cfg {
	bool loaded;

#define IWL_DBG_CFG(type, name)		type name;
#define IWL_DBG_CFG_NODEF(type, name)	type name;
#define IWL_DBG_CFG_DEF(type, name, v)	type name;
#define IWL_DBG_CFG_BIN(name)		struct iwl_dbg_cfg_bin name;
#define IWL_DBG_CFG_STR(name)	const char *name;
#define IWL_DBG_CFG_BINA(name, max)	struct iwl_dbg_cfg_bin name[max]; \
					int n_ ## name;
#define IWL_DBG_CFG_RANGE(type, name, min, max)	IWL_DBG_CFG(type, name)
#define IWL_MOD_PARAM(type, name)	/* do nothing */
#define IWL_MVM_MOD_PARAM(type, name)	type mvm_##name; \
					bool __mvm_mod_param_##name;
#define IWL_DBG_CFG_FN(name, fn)	/* nothing */

#endif /* DBG_CFG_REINCLUDE */
#if IS_ENABLED(CPTCFG_IWLXVT)
	IWL_DBG_CFG(u32, XVT_DEFAULT_DBGM_MEM_POWER)
	IWL_DBG_CFG(u32, XVT_DEFAULT_DBGM_LMAC_MASK)
	IWL_DBG_CFG(u32, XVT_DEFAULT_DBGM_PRPH_MASK)
	IWL_MOD_PARAM(bool, xvt_default_mode)
#endif
	IWL_DBG_CFG_NODEF(bool, disable_wrt_dump)
	IWL_DBG_CFG_NODEF(u32, wrt_filter_timepoints)
	IWL_DBG_CFG_NODEF(bool, disable_52GHz)
	IWL_DBG_CFG_NODEF(bool, disable_24GHz)
	IWL_DBG_CFG_DEF(bool, FW_MISBEHAVE_NMI,
			CPTCFG_IWLWIFI_FW_MISBEHAVE_NMI_DEFAULT)
	IWL_DBG_CFG_NODEF(bool, enable_dbg_asserts)
#if IS_ENABLED(CPTCFG_IWLMVM)
	IWL_DBG_CFG_NODEF(u32, MVM_CALIB_OVERRIDE_CONTROL)
	IWL_DBG_CFG_NODEF(u32, MVM_CALIB_INIT_FLOW)
	IWL_DBG_CFG_NODEF(u32, MVM_CALIB_INIT_EVENT)
	IWL_DBG_CFG_NODEF(u32, MVM_CALIB_D0_FLOW)
	IWL_DBG_CFG_NODEF(u32, MVM_CALIB_D0_EVENT)
	IWL_DBG_CFG_NODEF(u32, MVM_CALIB_D3_FLOW)
	IWL_DBG_CFG_NODEF(u32, MVM_CALIB_D3_EVENT)
	IWL_DBG_CFG_NODEF(bool, enable_timestamp_marker_cmd)
#endif
	IWL_DBG_CFG_NODEF(bool, STARTUP_RFKILL)
	IWL_DBG_CFG_NODEF(bool, mac80211_strict)
#if IS_ENABLED(CPTCFG_IWLMVM)
	IWL_DBG_CFG(u32, MVM_DEFAULT_PS_TX_DATA_TIMEOUT)
	IWL_DBG_CFG(u32, MVM_DEFAULT_PS_RX_DATA_TIMEOUT)
	IWL_DBG_CFG(u32, MVM_WOWLAN_PS_TX_DATA_TIMEOUT)
	IWL_DBG_CFG(u32, MVM_WOWLAN_PS_RX_DATA_TIMEOUT)
	IWL_DBG_CFG(u32, MVM_SHORT_PS_TX_DATA_TIMEOUT)
	IWL_DBG_CFG(u32, MVM_SHORT_PS_RX_DATA_TIMEOUT)
	IWL_DBG_CFG(u32, MVM_UAPSD_TX_DATA_TIMEOUT)
	IWL_DBG_CFG(u32, MVM_UAPSD_RX_DATA_TIMEOUT)
	IWL_DBG_CFG(u32, MVM_UAPSD_QUEUES)
	IWL_DBG_CFG_NODEF(bool, MVM_USE_PS_POLL)
	IWL_DBG_CFG(u8, MVM_PS_HEAVY_TX_THLD_PACKETS)
	IWL_DBG_CFG(u8, MVM_PS_HEAVY_RX_THLD_PACKETS)
	IWL_DBG_CFG(u8, MVM_PS_SNOOZE_HEAVY_TX_THLD_PACKETS)
	IWL_DBG_CFG(u8, MVM_PS_SNOOZE_HEAVY_RX_THLD_PACKETS)
	IWL_DBG_CFG(u8, MVM_PS_HEAVY_TX_THLD_PERCENT)
	IWL_DBG_CFG(u8, MVM_PS_HEAVY_RX_THLD_PERCENT)
	IWL_DBG_CFG(u16, MVM_PS_SNOOZE_INTERVAL)
	IWL_DBG_CFG(u16, MVM_PS_SNOOZE_WINDOW)
	IWL_DBG_CFG(u16, MVM_WOWLAN_PS_SNOOZE_WINDOW)
	IWL_DBG_CFG(u8, MVM_LOWLAT_QUOTA_MIN_PERCENT)
	IWL_DBG_CFG(u16, MVM_BT_COEX_EN_RED_TXP_THRESH)
	IWL_DBG_CFG(u16, MVM_BT_COEX_DIS_RED_TXP_THRESH)
	IWL_DBG_CFG(u32, MVM_BT_COEX_ANTENNA_COUPLING_THRS)
	IWL_DBG_CFG(u32, MVM_BT_COEX_MPLUT_REG0)
	IWL_DBG_CFG(u32, MVM_BT_COEX_MPLUT_REG1)
	IWL_DBG_CFG(bool, MVM_BT_COEX_SYNC2SCO)
	IWL_DBG_CFG(bool, MVM_BT_COEX_MPLUT)
	IWL_DBG_CFG(bool, MVM_BT_COEX_TTC)
	IWL_DBG_CFG(bool, MVM_BT_COEX_RRC)
	IWL_DBG_CFG(bool, MVM_FW_MCAST_FILTER_PASS_ALL)
	IWL_DBG_CFG(bool, MVM_FW_BCAST_FILTER_PASS_ALL)
	IWL_DBG_CFG(bool, MVM_TOF_IS_RESPONDER)
	IWL_DBG_CFG(bool, MVM_P2P_LOWLATENCY_PS_ENABLE)
	IWL_DBG_CFG(bool, MVM_ADWELL_ENABLE)
	IWL_DBG_CFG(u16, MVM_ADWELL_MAX_BUDGET)
	IWL_DBG_CFG(u32, MVM_TCM_LOAD_MEDIUM_THRESH)
	IWL_DBG_CFG(u32, MVM_TCM_LOAD_HIGH_THRESH)
	IWL_DBG_CFG(u32, MVM_TCM_LOWLAT_ENABLE_THRESH)
	IWL_DBG_CFG(u32, MVM_UAPSD_NONAGG_PERIOD)
	IWL_DBG_CFG_RANGE(u8, MVM_UAPSD_NOAGG_LIST_LEN,
			  1, IWL_MVM_UAPSD_NOAGG_BSSIDS_NUM)
	IWL_DBG_CFG(bool, MVM_NON_TRANSMITTING_AP)
	IWL_DBG_CFG(u16, MVM_CONN_LISTEN_INTERVAL)
	IWL_DBG_CFG_NODEF(u32, MVM_PHY_FILTER_CHAIN_A)
	IWL_DBG_CFG_NODEF(u32, MVM_PHY_FILTER_CHAIN_B)
	IWL_DBG_CFG_NODEF(u32, MVM_PHY_FILTER_CHAIN_C)
	IWL_DBG_CFG_NODEF(u32, MVM_PHY_FILTER_CHAIN_D)
	IWL_DBG_CFG(u8, MVM_QUOTA_THRESHOLD)
	IWL_DBG_CFG(u8, MVM_RS_RSSI_BASED_INIT_RATE)
	IWL_DBG_CFG(u8, MVM_RS_80_20_FAR_RANGE_TWEAK)
	IWL_DBG_CFG(u8, MVM_RS_NUM_TRY_BEFORE_ANT_TOGGLE)
	IWL_DBG_CFG(u8, MVM_RS_HT_VHT_RETRIES_PER_RATE)
	IWL_DBG_CFG(u8, MVM_RS_HT_VHT_RETRIES_PER_RATE_TW)
	IWL_DBG_CFG(u8, MVM_RS_INITIAL_MIMO_NUM_RATES)
	IWL_DBG_CFG(u8, MVM_RS_INITIAL_SISO_NUM_RATES)
	IWL_DBG_CFG(u8, MVM_RS_INITIAL_LEGACY_NUM_RATES)
	IWL_DBG_CFG(u8, MVM_RS_INITIAL_LEGACY_RETRIES)
	IWL_DBG_CFG(u8, MVM_RS_SECONDARY_LEGACY_RETRIES)
	IWL_DBG_CFG(u8, MVM_RS_SECONDARY_LEGACY_NUM_RATES)
	IWL_DBG_CFG(u8, MVM_RS_SECONDARY_SISO_NUM_RATES)
	IWL_DBG_CFG(u8, MVM_RS_SECONDARY_SISO_RETRIES)
	IWL_DBG_CFG(u8, MVM_RS_RATE_MIN_FAILURE_TH)
	IWL_DBG_CFG(u8, MVM_RS_RATE_MIN_SUCCESS_TH)
	IWL_DBG_CFG(u8, MVM_RS_STAY_IN_COLUMN_TIMEOUT)
	IWL_DBG_CFG(u8, MVM_RS_IDLE_TIMEOUT)
	IWL_DBG_CFG(u8, MVM_RS_MISSED_RATE_MAX)
	IWL_DBG_CFG(u16, MVM_RS_LEGACY_FAILURE_LIMIT)
	IWL_DBG_CFG(u16, MVM_RS_LEGACY_SUCCESS_LIMIT)
	IWL_DBG_CFG(u16, MVM_RS_LEGACY_TABLE_COUNT)
	IWL_DBG_CFG(u16, MVM_RS_NON_LEGACY_FAILURE_LIMIT)
	IWL_DBG_CFG(u16, MVM_RS_NON_LEGACY_SUCCESS_LIMIT)
	IWL_DBG_CFG(u16, MVM_RS_NON_LEGACY_TABLE_COUNT)
	IWL_DBG_CFG(u16, MVM_RS_SR_FORCE_DECREASE)
	IWL_DBG_CFG(u16, MVM_RS_SR_NO_DECREASE)
	IWL_DBG_CFG(u16, MVM_RS_AGG_TIME_LIMIT)
	IWL_DBG_CFG(u8, MVM_RS_AGG_DISABLE_START)
	IWL_DBG_CFG(u8, MVM_RS_AGG_START_THRESHOLD)
	IWL_DBG_CFG(u16, MVM_RS_TPC_SR_FORCE_INCREASE)
	IWL_DBG_CFG(u16, MVM_RS_TPC_SR_NO_INCREASE)
	IWL_DBG_CFG(u8, MVM_RS_TPC_TX_POWER_STEP)
	IWL_DBG_CFG(bool, MVM_ENABLE_EBS)
	IWL_DBG_CFG_NODEF(u16, MVM_FTM_RESP_TOA_OFFSET)
	IWL_DBG_CFG_NODEF(u32, MVM_FTM_RESP_VALID)
	IWL_DBG_CFG_NODEF(u32, MVM_FTM_RESP_FLAGS)
	IWL_DBG_CFG(bool, MVM_FTM_RESP_NDP_SUPPORT)
	IWL_DBG_CFG(bool, MVM_FTM_RESP_LMR_FEEDBACK_SUPPORT)
	IWL_DBG_CFG(u8, MVM_FTM_INITIATOR_ALGO)
	IWL_DBG_CFG(bool, MVM_FTM_INITIATOR_DYNACK)
	IWL_DBG_CFG(bool, MVM_FTM_LMR_FEEDBACK_TERMINATE)
	IWL_DBG_CFG(bool, MVM_FTM_TEST_INCORRECT_SAC)
	IWL_DBG_CFG_NODEF(bool, MVM_FTM_TEST_BAD_SLTF)
	IWL_DBG_CFG_NODEF(bool, MVM_FTM_INITIATOR_MCSI_ENABLED)
	IWL_DBG_CFG_NODEF(int, MVM_FTM_INITIATOR_COMMON_CALIB)
	IWL_DBG_CFG_NODEF(bool, MVM_FTM_INITIATOR_FAST_ALGO_DISABLE)
	IWL_DBG_CFG_RANGE(u8, MVM_FTM_R2I_MAX_REP, 0, 7)
	IWL_DBG_CFG_RANGE(u8, MVM_FTM_I2R_MAX_REP, 0, 7)
	IWL_DBG_CFG_RANGE(u8, MVM_FTM_R2I_MAX_STS, 0, 7)
	IWL_DBG_CFG_RANGE(u8, MVM_FTM_I2R_MAX_STS, 0, 7)
	IWL_DBG_CFG_RANGE(u8, MVM_FTM_R2I_MAX_TOTAL_LTF, 0, 3)
	IWL_DBG_CFG_RANGE(u8, MVM_FTM_I2R_MAX_TOTAL_LTF, 0, 3)
	IWL_DBG_CFG(bool, MVM_FTM_INITIATOR_SECURE_LTF)
	IWL_DBG_CFG(u16, MVM_FTM_NON_TB_MIN_TIME_BETWEEN_MSR)
	IWL_DBG_CFG(u16, MVM_FTM_NON_TB_MAX_TIME_BETWEEN_MSR)
	IWL_DBG_CFG(bool, MVM_D3_DEBUG)
	IWL_DBG_CFG(bool, MVM_USE_TWT)
	IWL_DBG_CFG(bool, MVM_TWT_TESTMODE)
	IWL_DBG_CFG(u32, MVM_AMPDU_CONSEC_DROPS_DELBA)
	IWL_MVM_MOD_PARAM(int, power_scheme)
	IWL_DBG_CFG(bool, MVM_FTM_INITIATOR_ENABLE_SMOOTH)
	IWL_DBG_CFG_RANGE(u8, MVM_FTM_INITIATOR_SMOOTH_ALPHA, 0, 100)
	/* 667200 is 200m RTT */
	IWL_DBG_CFG_RANGE(u32, MVM_FTM_INITIATOR_SMOOTH_UNDERSHOOT, 0, 667200)
	IWL_DBG_CFG_RANGE(u32, MVM_FTM_INITIATOR_SMOOTH_OVERSHOOT, 0, 667200)
	IWL_DBG_CFG(u32, MVM_FTM_INITIATOR_SMOOTH_AGE_SEC)
	IWL_DBG_CFG(bool, MVM_DISABLE_AP_FILS)
	IWL_DBG_CFG(u32, MVM_6GHZ_PASSIVE_SCAN_TIMEOUT)
	IWL_DBG_CFG(u32, MVM_6GHZ_PASSIVE_SCAN_ASSOC_TIMEOUT)
	IWL_DBG_CFG_NODEF(u32, system_features_control_1)
	IWL_DBG_CFG_NODEF(u32, system_features_control_2)
	IWL_DBG_CFG_NODEF(u32, system_features_control_3)
	IWL_DBG_CFG_NODEF(u32, system_features_control_4)
	IWL_DBG_CFG(bool, MVM_MEI_REPORT_RFKILL)
	IWL_DBG_CFG(u8, MVM_MIN_BEACON_INTERVAL_TU)
	IWL_DBG_CFG_RANGE(u8, MVM_ADAPTIVE_DWELL_NUM_APS_OVERRIDE, 0, 10)
	IWL_DBG_CFG(bool, MVM_AUTO_EML_ENABLE)

#endif /* CPTCFG_IWLMVM */
#if IS_ENABLED(CPTCFG_IWLMLD)
	IWL_DBG_CFG_NODEF(bool, MLD_RANDOM_NMI_ENABLE)
	IWL_DBG_CFG_DEF(u8, MLD_RANDOM_NMI_CEIL, U8_MAX)
	IWL_DBG_CFG_NODEF(u8, MLD_RANDOM_NMI_FLOOR)
	IWL_DBG_CFG_NODEF(u8, MLD_RANDOM_NMI_LIMIT)
	IWL_DBG_CFG_NODEF(bool, MLD_DIS_RANDOM_FW_ID)
	IWL_DBG_CFG(bool, MLD_D3_DEBUG)
	IWL_DBG_CFG_NODEF(bool, MLD_NON_TRANSMITTING_AP)
	IWL_DBG_CFG(u32, MLD_6GHZ_PASSIVE_SCAN_TIMEOUT)
	IWL_DBG_CFG(u32, MLD_6GHZ_PASSIVE_SCAN_ASSOC_TIMEOUT)
	IWL_DBG_CFG(u16, MLD_CONN_LISTEN_INTERVAL)
	IWL_DBG_CFG_NODEF(bool, MLD_TWT_TESTMODE)
	IWL_DBG_CFG_RANGE(u8, MLD_ADAPTIVE_DWELL_NUM_APS_OVERRIDE, 0, 10)

	IWL_DBG_CFG(bool, MLD_AUTO_EML_ENABLE)

	IWL_DBG_CFG(int, MLD_HIGH_RSSI_THRESH_20MHZ)
	IWL_DBG_CFG(int, MLD_LOW_RSSI_THRESH_20MHZ)
	IWL_DBG_CFG(int, MLD_HIGH_RSSI_THRESH_40MHZ)
	IWL_DBG_CFG(int, MLD_LOW_RSSI_THRESH_40MHZ)
	IWL_DBG_CFG(int, MLD_HIGH_RSSI_THRESH_80MHZ)
	IWL_DBG_CFG(int, MLD_LOW_RSSI_THRESH_80MHZ)
	IWL_DBG_CFG(int, MLD_HIGH_RSSI_THRESH_160MHZ)
	IWL_DBG_CFG(int, MLD_LOW_RSSI_THRESH_160MHZ)

	IWL_DBG_CFG(int, MLD_ENTER_EMLSR_TPT_THRESH)
	IWL_DBG_CFG(int, MLD_EXIT_EMLSR_CHAN_LOAD)
	IWL_DBG_CFG_DEF(int, MLD_ENTER_EMLSR_CHAN_LOAD, -1)
	IWL_DBG_CFG_NODEF(bool, MLD_ENTER_EMLSR_UNEQUAL_BW)
	IWL_DBG_CFG_NODEF(bool, MLD_SNIFFER_REDUCED_SENSITIVITY)

	IWL_DBG_CFG(bool, MLD_FTM_RESP_LMR_FEEDBACK_SUPPORT)
	IWL_DBG_CFG(u8, MLD_FTM_INITIATOR_ALGO)
	IWL_DBG_CFG(bool, MLD_FTM_INITIATOR_DYNACK)
	IWL_DBG_CFG(bool, MLD_FTM_LMR_FEEDBACK_TERMINATE)
	IWL_DBG_CFG(bool, MLD_FTM_TEST_INCORRECT_SAC)
	IWL_DBG_CFG_NODEF(bool, MLD_FTM_TEST_BAD_SLTF)
	IWL_DBG_CFG_NODEF(bool, MLD_FTM_INITIATOR_MCSI_ENABLED)
	IWL_DBG_CFG_NODEF(int, MLD_FTM_INITIATOR_COMMON_CALIB)
	IWL_DBG_CFG_NODEF(bool, MLD_FTM_INITIATOR_FAST_ALGO_DISABLE)
	IWL_DBG_CFG_RANGE(u8, MLD_FTM_R2I_MAX_REP, 0, 7)
	IWL_DBG_CFG_RANGE(u8, MLD_FTM_I2R_MAX_REP, 0, 7)
	IWL_DBG_CFG_RANGE(u8, MLD_FTM_R2I_MAX_STS, 0, 7)
	IWL_DBG_CFG_RANGE(u8, MLD_FTM_I2R_MAX_STS, 0, 7)
	IWL_DBG_CFG_RANGE(u8, MLD_FTM_R2I_MAX_TOTAL_LTF, 0, 3)
	IWL_DBG_CFG_RANGE(u8, MLD_FTM_I2R_MAX_TOTAL_LTF, 0, 3)
	IWL_DBG_CFG(u16, MLD_FTM_NON_TB_MIN_TIME_BETWEEN_MSR)
	IWL_DBG_CFG(u16, MLD_FTM_NON_TB_MAX_TIME_BETWEEN_MSR)
	IWL_DBG_CFG(bool, MLD_FTM_INITIATOR_SECURE_LTF)
	IWL_DBG_CFG_NODEF(u32, MLD_FTM_RESP_VALID)
	IWL_DBG_CFG_NODEF(u32, MLD_FTM_RESP_FLAGS)
	IWL_DBG_CFG_NODEF(u16, MLD_FTM_RESP_TOA_OFFSET)

#endif /* CPTCFG_IWLMLD */
	IWL_DBG_CFG_BIN(hw_address)
	IWL_DBG_CFG_STR(fw_dbg_conf)
	IWL_DBG_CFG_STR(nvm_file)
	IWL_DBG_CFG_STR(fw_file_pre)
	IWL_DBG_CFG_NODEF(u32, valid_ants)
	IWL_DBG_CFG_NODEF(u32, no_ack_en)
	IWL_DBG_CFG_NODEF(u32, ack_en)
	IWL_DBG_CFG_NODEF(bool, no_ldpc)
	IWL_DBG_CFG_NODEF(bool, smps_disabled)
	IWL_DBG_CFG_NODEF(u16, rx_agg_subframes)
	IWL_DBG_CFG_NODEF(bool, tx_siso_80bw_like_160bw)
	IWL_DBG_CFG_NODEF(u16, ampdu_limit)
	IWL_DBG_CFG_NODEF(u16, rx_mcs_80)
	IWL_DBG_CFG_NODEF(u16, tx_mcs_80)
	IWL_DBG_CFG_NODEF(u16, rx_mcs_160)
	IWL_DBG_CFG_NODEF(u16, tx_mcs_160)
	IWL_DBG_CFG_NODEF(u32, secure_boot_cfg)
	IWL_MOD_PARAM(u32, uapsd_disable)
	IWL_MOD_PARAM(bool, fw_restart)
	IWL_MOD_PARAM(bool, power_save)
	IWL_MOD_PARAM(bool, bt_coex_active)
	IWL_MOD_PARAM(int, power_level)
	IWL_MOD_PARAM(int, led_mode)
	IWL_MOD_PARAM(int, amsdu_size)
	IWL_MOD_PARAM(int, swcrypto)
	IWL_MOD_PARAM(uint, disable_11n)
	IWL_MOD_PARAM(u32, enable_ini)
	IWL_MOD_PARAM(bool, disable_11ac)
	IWL_MOD_PARAM(bool, disable_11ax)
	IWL_MOD_PARAM(bool, disable_11be)
	IWL_DBG_CFG_BIN(he_ppe_thres)
	IWL_DBG_CFG_NODEF(u8, he_chan_width_dis)
	IWL_DBG_CFG_NODEF(u32, vht_cap_flip)
	IWL_DBG_CFG_NODEF(u32, mu_edca)
	IWL_DBG_CFG_NODEF(u32, disable_ht40)
	IWL_DBG_CFG_BIN(he_mac_cap)
	IWL_DBG_CFG_BIN(he_phy_cap)
	IWL_DBG_CFG_BIN(eht_ppe_thres)
	IWL_DBG_CFG_BIN(eht_mac_cap)
	IWL_DBG_CFG_BIN(eht_phy_cap)
	IWL_DBG_CFG_BIN(eht_mcs_only_20Mhz)
	IWL_DBG_CFG_BIN(eht_mcs_80)
	IWL_DBG_CFG_BIN(eht_mcs_160)
	IWL_DBG_CFG_BIN(eht_mcs_320)
	IWL_DBG_CFG_NODEF(bool, eht_disable_320)
	IWL_DBG_CFG(u32, FW_DBG_DOMAIN)
	IWL_DBG_CFG_FN(FW_DBG_PRESET, iwl_dbg_cfg_parse_fw_dbg_preset)
	IWL_DBG_CFG_NODEF(bool, he_smps_disabled)
	IWL_DBG_CFG_NODEF(bool, ht_dynamic_smps)
	IWL_DBG_CFG_NODEF(bool, amsdu_in_ampdu_disabled)
	IWL_DBG_CFG_NODEF(u32, step_analog_params)
	IWL_DBG_CFG_NODEF(bool, DISABLE_SPP_AMSDU_ADV)
	IWL_DBG_CFG_DEF(int, SPP_AMSDU_ACTIVATE, -1)
	IWL_DBG_CFG_NODEF(bool, HW_CSUM_DISABLE)
	IWL_DBG_CFG_NODEF(bool, allow_twt)
	IWL_DBG_CFG_STR(ppag_allowed)
	IWL_DBG_CFG_STR(tas_allowed)
	IWL_DBG_CFG_NODEF(bool, DISABLE_STUCK_TIMER)
	IWL_DBG_CFG_NODEF(bool, disable_eml)
	IWL_DBG_CFG_DEF(int, eml_capa_override, -1)
	IWL_DBG_CFG_DEF(bool, load_external_fseq, false)
	IWL_DBG_CFG_NODEF(bool, load_external_pnvm)
#ifdef CPTCFG_IWLWIFI_DEBUG
	IWL_MOD_PARAM(u32, debug_level)
#endif /* CPTCFG_IWLWIFI_DEBUG */
#ifdef CPTCFG_IWLWIFI_DISALLOW_OLDER_FW
	IWL_DBG_CFG_NODEF(bool, load_old_fw)
#endif /* CPTCFG_IWLWIFI_DISALLOW_OLDER_FW */
#undef IWL_DBG_CFG
#undef IWL_DBG_CFG_STR
#undef IWL_DBG_CFG_NODEF
#undef IWL_DBG_CFG_DEF
#undef IWL_DBG_CFG_BIN
#undef IWL_DBG_CFG_BINA
#undef IWL_DBG_CFG_RANGE
#undef IWL_MOD_PARAM
#undef IWL_MVM_MOD_PARAM
#undef IWL_DBG_CFG_FN
#ifndef DBG_CFG_REINCLUDE
};

extern const struct iwl_dbg_cfg default_dbg_config;
void iwl_dbg_cfg_free(struct iwl_dbg_cfg *dbgcfg);
void iwl_dbg_cfg_load_ini(struct device *dev, struct iwl_dbg_cfg *dbgcfg);
#endif /* DBG_CFG_REINCLUDE */

#endif /* __IWL_DBG_CFG_H__ || DBG_CFG_REINCLUDE */
