#!/bin/sh
#
# SPDX-FileCopyrightText: Peter Pentchev <roam@ringlet.net>
# SPDX-License-Identifier: GPL-2.0-or-later

myself="$(readlink -f -- "$0")"
test_dir="$(dirname -- "$myself")"
. "$test_dir/tap-functions.sh"

[ -z "$PRIPS" ] && PRIPS='./prips'

plan_ 15

echo '# prips with no arguments should exit with code 1'
$PRIPS > /dev/null 2>&1
res="$?"
if [ "$res" = 1 ]; then ok_; else not_ok_ "exit code $res"; fi

v=`$PRIPS -d33 127.0.0.4 127.0.0.5 2>/dev/null`
res="$?"
exp='127.0.0.4!127.0.0.5!'
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ "$v" = "$exp" ]; then ok_; else not_ok_ "expected $exp got $v"; fi

v=`$PRIPS -d33 127.0.0.4 127.0.0.7 2>/dev/null`
res="$?"
exp='127.0.0.4!127.0.0.5!127.0.0.6!127.0.0.7!'
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ "$v" = "$exp" ]; then ok_; else not_ok_ "expected $exp got $v"; fi

v=`$PRIPS -d33 127.0.0.7 127.0.0.4 2>/dev/null`
res="$?"
if [ "$res" = 1 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ -z "$v" ]; then ok_; else not_ok_ "expected $exp got $v"; fi

v=`$PRIPS -d33 255.255.255.252/30 2>/dev/null`
res="$?"
exp='255.255.255.252!255.255.255.253!255.255.255.254!255.255.255.255!'
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ "$v" = "$exp" ]; then ok_; else not_ok_ "expected $exp got $v"; fi

v=`$PRIPS -d33 255.255.255.252 255.255.255.255 2>/dev/null`
res="$?"
exp='255.255.255.252!255.255.255.253!255.255.255.254!255.255.255.255!'
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ "$v" = "$exp" ]; then ok_; else not_ok_ "expected $exp got $v"; fi

v=`$PRIPS -d33 255.255.255.255 255.255.255.255 2>/dev/null`
res="$?"
exp='255.255.255.255!'
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ "$v" = "$exp" ]; then ok_; else not_ok_ "expected $exp got $v"; fi

v=`$PRIPS -d33 255.255.255.255/32 2>/dev/null`
res="$?"
exp='255.255.255.255!'
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ "$v" = "$exp" ]; then ok_; else not_ok_ "expected $exp got $v"; fi
