/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ComboCompletionDialog
extends JDialog {
    private String result = null;
    public String escapeChars = ";(= \t\n";
    public String[] items;
    private JList jLstItems;
    private JScrollPane jScrollPane1;
    private JTextField jTxtItem;

    public ComboCompletionDialog(Frame parent, boolean modal, String[] items) {
        super(parent, modal);
        this.initComponents();
        this.items = items;
        this.jLstItems.setListData(items);
        this.jTxtItem.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ComboCompletionDialog.this.refilterList();
            }

            public void removeUpdate(DocumentEvent e) {
                ComboCompletionDialog.this.refilterList();
            }

            public void changedUpdate(DocumentEvent e) {
                ComboCompletionDialog.this.refilterList();
            }
        });
        this.jTxtItem.setFocusTraversalKeysEnabled(false);
    }

    public void setFonts(Font font) {
        this.jTxtItem.setFont(font);
        this.jLstItems.setFont(font);
        this.doLayout();
    }

    public void setText(String abbrev) {
        this.jTxtItem.setText(abbrev);
    }

    private void refilterList() {
        String prefix = this.jTxtItem.getText();
        Vector<String> filtered = new Vector<String>();
        Object selected = this.jLstItems.getSelectedValue();
        for (String s : this.items) {
            if (!s.startsWith(prefix)) continue;
            filtered.add(this.trimPrefix(s));
        }
        this.jLstItems.setListData(filtered);
        if (selected != null) {
            this.jLstItems.setSelectedValue(selected, true);
        } else {
            this.jLstItems.setSelectedIndex(0);
        }
    }

    private String trimPrefix(String item) {
        int idx1 = item.indexOf("[");
        int idx2 = item.indexOf("]");
        if (idx1 > -1 && idx2 > -1) {
            return (idx1 > 0 ? item.substring(0, idx1 - 1) : "") + (idx2 < item.length() - 1 ? item.substring(idx2 + 1) : "");
        }
        return item;
    }

    private void initComponents() {
        this.jTxtItem = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jLstItems = new JList();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setUndecorated(true);
        this.jTxtItem.setBorder(null);
        this.jTxtItem.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                ComboCompletionDialog.this.jTxtItemKeyPressed(evt);
            }
        });
        this.jLstItems.setSelectionMode(0);
        this.jLstItems.setFocusable(false);
        this.jScrollPane1.setViewportView(this.jLstItems);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTxtItem, -1, 270, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 270, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTxtItem, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 111, Short.MAX_VALUE)));
        this.pack();
    }

    private void jTxtItemKeyPressed(KeyEvent evt) {
        int i = this.jLstItems.getSelectedIndex();
        switch (evt.getKeyCode()) {
            case 27: {
                this.result = this.jTxtItem.getText();
                this.setVisible(false);
                return;
            }
            case 40: {
                if (i < this.jLstItems.getModel().getSize() - 1) {
                    ++i;
                }
                this.jLstItems.setSelectedIndex(i);
                this.jLstItems.ensureIndexIsVisible(i);
                break;
            }
            case 38: {
                if (i > 0) {
                    --i;
                }
                this.jLstItems.setSelectedIndex(i);
                this.jLstItems.ensureIndexIsVisible(i);
            }
        }
        if (this.escapeChars.indexOf(evt.getKeyChar()) >= 0) {
            this.result = this.jLstItems.getSelectedIndex() >= 0 ? this.jLstItems.getSelectedValue().toString() : this.jTxtItem.getText();
            char pressed = evt.getKeyChar();
            if (pressed != '\n') {
                this.result = this.result + (pressed == '\t' ? (char)' ' : (char)pressed);
            }
            this.setVisible(false);
        }
    }

    public String getResult() {
        return this.result == null ? "" : this.trimPrefix(this.result);
    }
}

