% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_genes_in_pseudotime}
\alias{plot_genes_in_pseudotime}
\title{Plots expression for one or more genes as a function of pseudotime}
\usage{
plot_genes_in_pseudotime(cds_subset, min_expr = NULL, cell_size = 0.75,
  nrow = NULL, ncol = 1, panel_order = NULL, color_by = "State",
  trend_formula = "~ sm.ns(Pseudotime, df=3)", label_by_short_name = TRUE,
  relative_expr = TRUE, vertical_jitter = NULL, horizontal_jitter = NULL)
}
\arguments{
\item{cds_subset}{CellDataSet for the experiment}

\item{min_expr}{the minimum (untransformed) expression level to use in plotted the genes.}

\item{cell_size}{the size (in points) of each cell used in the plot}

\item{nrow}{the number of rows used when laying out the panels for each gene's expression}

\item{ncol}{the number of columns used when laying out the panels for each gene's expression}

\item{panel_order}{the order in which genes should be layed out (left-to-right, top-to-bottom)}

\item{color_by}{the cell attribute (e.g. the column of pData(cds)) to be used to color each cell}

\item{trend_formula}{the model formula to be used for fitting the expression trend over pseudotime}

\item{label_by_short_name}{label figure panels by gene_short_name (TRUE) or feature id (FALSE)}

\item{relative_expr}{Whether to transform expression into relative values}

\item{vertical_jitter}{A value passed to ggplot to jitter the points in the vertical dimension. Prevents overplotting, and is particularly helpful for rounded transcript count data.}

\item{horizontal_jitter}{A value passed to ggplot to jitter the points in the horizontal dimension. Prevents overplotting, and is particularly helpful for rounded transcript count data.}
}
\value{
a ggplot2 plot object
}
\description{
Plots expression for one or more genes as a function of pseudotime.
Plotting allows you determine if the ordering produced by orderCells() is correct
and it does not need to be flipped using the "reverse" flag in orderCells
}
\examples{
\dontrun{
library(HSMMSingleCell)
HSMM <- load_HSMM()
my_genes <- row.names(subset(fData(HSMM), gene_short_name \%in\% c("CDK1", "MEF2C", "MYH3"))) 
cds_subset <- HSMM[my_genes,]
plot_genes_in_pseudotime(cds_subset, color_by="Time")
}
}
