//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armbatch

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000)
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAccountClient creates a new instance of AccountClient.
func (c *ClientFactory) NewAccountClient() *AccountClient {
	subClient, _ := NewAccountClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewApplicationClient creates a new instance of ApplicationClient.
func (c *ClientFactory) NewApplicationClient() *ApplicationClient {
	subClient, _ := NewApplicationClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewApplicationPackageClient creates a new instance of ApplicationPackageClient.
func (c *ClientFactory) NewApplicationPackageClient() *ApplicationPackageClient {
	subClient, _ := NewApplicationPackageClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCertificateClient creates a new instance of CertificateClient.
func (c *ClientFactory) NewCertificateClient() *CertificateClient {
	subClient, _ := NewCertificateClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLocationClient creates a new instance of LocationClient.
func (c *ClientFactory) NewLocationClient() *LocationClient {
	subClient, _ := NewLocationClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewPoolClient creates a new instance of PoolClient.
func (c *ClientFactory) NewPoolClient() *PoolClient {
	subClient, _ := NewPoolClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionClient creates a new instance of PrivateEndpointConnectionClient.
func (c *ClientFactory) NewPrivateEndpointConnectionClient() *PrivateEndpointConnectionClient {
	subClient, _ := NewPrivateEndpointConnectionClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkResourceClient creates a new instance of PrivateLinkResourceClient.
func (c *ClientFactory) NewPrivateLinkResourceClient() *PrivateLinkResourceClient {
	subClient, _ := NewPrivateLinkResourceClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
